#include "common.h"

#include <vector>

class Sensor {
  public:
    explicit Sensor(SENSOR_TYPE id);

    virtual void updateState() = 0;
    virtual Data dataToSend() = 0;
    virtual void resetState() = 0;
    SENSOR_TYPE getId() { return sensor_id_; };

 protected:
  SENSOR_TYPE sensor_id_;
};

class DigitalSensor: public Sensor {
  public:
    explicit DigitalSensor(SENSOR_TYPE id, PinName pin=PA_10);

    virtual void updateState();
    virtual Data dataToSend();
    virtual void resetState();

    static const float SEND_INTERVAL;
  private:
    DigitalIn sensor_;
    bool last_state_;
    int32_t changes_counter_;
};

class AnalogSensor: public Sensor {
  public:
    explicit AnalogSensor(SENSOR_TYPE id, PinName pin=PA_4);

    virtual void updateState();
    virtual Data dataToSend();
    virtual void resetState();

    static const float SEND_INTERVAL;
  protected:
    AnalogIn sensor_;
};


class SoundSensor: public AnalogSensor {
  public:
    explicit SoundSensor(SENSOR_TYPE id, PinName pin=PA_4);

    virtual void updateState();
    virtual Data dataToSend();
    virtual void resetState();

  private:
    std::vector<float> values_;
};