#!/usr/bin/python

from flask import Flask, jsonify
from coapserver import CoAPServer
from databaseconnector import DatabaseConnector

app = Flask(__name__)


host = '46.101.12.31'
# host = "localhost"
coapport = 4242
database = '/home/jan/server/kubus.db'
# database = "kubus.db"
tables = ['pir1', 'pir2', 'distance', 'volume']
connector = DatabaseConnector(database=database, tables=tables)


@app.route("/")
def all():
    d = connector.read()
    return jsonify(**d)


if __name__ == '__main__':
    coapserver = CoAPServer(host, coapport, tables, connector)
    coapserver.daemon = True
    coapserver.start()
    app.run()
    coapserver.close()
