#include "common.h"
#include "sensor.h"
#include <vector>

class Board {
  public:
    explicit Board(unsigned long long rx_address, DigitalSensor* digital_sensor,
                   AnalogSensor* analog_sensor, unsigned long long tx_address=MASTER_ADDRESS);

    void run();

    static const int MAX_RETRY;
    static const float UPDATE_INTERVAL;
  private:
    int getRandomWaitMs();
    bool sendByRadio(char message[TRANSFER_SIZE]);
    void displayRadioSetup();
    bool send(int id, Data data_to_send);
    void updateSensor(Sensor* sensor, bool* should_send_data);

    Serial pc_;
    nRF24L01P radio_;
    AnalogSensor* analog_sensor_;
    DigitalSensor* digital_sensor_;
    Ticker analog_ticker_;
    Ticker digital_ticker_;
    Ticker analog_update_;
};
