#include "common.h"
#include "master.h"
#include "sensor_board.h"

const int MASTER_MODE = 0;
const int BOARD1_MODE = 1;
const int BOARD2_MODE = 2;
const int BOARD3_MODE = 3;

// Note: choose mode using MODE macro!
int main() {
    switch(MODE) {
        case MASTER_MODE: {
            master_loop();
            break;
        } case BOARD1_MODE: {
            DigitalSensor pir1(PIR1);
            SoundSensor sound_sensor(SOUND, PA_1);
            Board(BOARD1_ADDRESS, &pir1, &sound_sensor).run();
            break;
        } case BOARD2_MODE: {
            DigitalSensor pir2(PIR2);
            Board(BOARD2_ADDRESS, &pir2, NULL).run();
            break;
        } case BOARD3_MODE: {
            AnalogSensor distance_sensor(DISTANCE);
            Board(BOARD3_ADDRESS, NULL, &distance_sensor).run();
            break;
        }
    }
    return 0;
}
