#include "sensor.h"

#include <algorithm>

Sensor::Sensor(SENSOR_TYPE id) : sensor_id_(id) {}

const float DigitalSensor::SEND_INTERVAL = 10.0;

DigitalSensor::DigitalSensor(SENSOR_TYPE id, PinName pin) :
        Sensor(id), sensor_(DigitalIn(pin)),
        last_state_(false), changes_counter_(0) {
    sensor_.mode(PullDown);
}

void DigitalSensor::updateState() {
    bool state = sensor_.read();

    if (last_state_ != state) {
        last_state_ = state;
        changes_counter_++;
    }
}

Data DigitalSensor::dataToSend() {
    return Data(sensor_id_, changes_counter_);
}

void DigitalSensor::resetState() {
    changes_counter_ = 0;
}

const float AnalogSensor::SEND_INTERVAL = 8.0;

AnalogSensor::AnalogSensor(SENSOR_TYPE id, PinName pin) :
        Sensor(id), sensor_(AnalogIn(pin)) {
}

void AnalogSensor::updateState() {}

Data AnalogSensor::dataToSend() {
    float data_read = sensor_.read();
    return Data(sensor_id_, data_read);
}

void AnalogSensor::resetState() {}

SoundSensor::SoundSensor(SENSOR_TYPE id, PinName pin) :
        AnalogSensor(id, pin), values_() {
}

void SoundSensor::updateState() {
    float data_read = sensor_.read();
    values_.push_back(data_read);
}

Data SoundSensor::dataToSend() {
    std::sort(values_.begin(), values_.end());
    int q3_index = values_.size() * 0.75;
    float q3 = values_[q3_index];
    return Data(sensor_id_, q3);
}

void SoundSensor::resetState() {
    values_.clear();
}


