#include "common.h"
#include <cstring>

std::string Data::serialize() {
    std::string serialized;
    serialized.push_back(type);
    serialized.append((char*)&value, sizeof(value));
    return serialized;
};
bool Data::deserialize(std::string str) {
    if(str.length() < 1 + sizeof(value)) {
        return false;
    }
    type = str[0];
    memcpy(&value, str.data() + 1, sizeof(value));
    return true;
}

std::string str_hex(const char* text, int len) {
    std::stringstream ss;

    for (int i = 0; i < len; ++i) {
        ss << std::hex << text[i] / 16 << text[i] % 16; // ugly!
    }

    return ss.str();
}

void radio_init(nRF24L01P* radio, unsigned long long rx_address,
        unsigned long long tx_address) {
    radio->powerDown();
    radio->powerUp();

    radio->setAirDataRate(DATA_RATE);
    radio->setRfOutputPower(POWER);
    radio->setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY + 4 * CHANNEL);

    radio->setCrcWidth(NRF24L01P_CRC_8_BIT);
    radio->enableAutoAcknowledge(NRF24L01P_PIPE_P0);
    radio->enableAutoAcknowledge(NRF24L01P_PIPE_P1);
    radio->enableAutoRetransmit(0x0F, 0x0F);

    radio->setTxAddress(tx_address, 4);
    radio->setRxAddress(tx_address, 4, NRF24L01P_PIPE_P0);
    radio->setRxAddress(rx_address, 4, NRF24L01P_PIPE_P1);

    radio->setTransferSize(TRANSFER_SIZE, NRF24L01P_PIPE_P0);
    radio->setTransferSize(TRANSFER_SIZE, NRF24L01P_PIPE_P1);

    radio->setReceiveMode();
    radio->enable();
}
