#include "common.h"
#include "master.h"

#include "cantcoap.h"
#include <sstream>

int master_loop() {
    Serial pc(USBTX, USBRX); // tx, rx
    Serial wifi(PA_9, PA_10);
    DigitalOut frm(PC_8);
    nRF24L01P radio(PB_15, PB_14, PB_13, PB_12, PB_1, PB_2);    // mosi, miso, sck, csn, ce, irq

    const unsigned long long RX_ADDRESS = MASTER_ADDRESS;
    const unsigned long long TX_ADDRESS = BOARD1_ADDRESS;

    char rxData[TRANSFER_SIZE];

    pc.baud(115200);
    wifi.baud(115200);

    radio_init(&radio, RX_ADDRESS, TX_ADDRESS);

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  radio.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  radio.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", radio.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", radio.getTxAddress() );
    pc.printf( "nRF24L01+ RX0 Address   : 0x%010llX\r\n", radio.getRxAddress(NRF24L01P_PIPE_P0) );
    pc.printf( "nRF24L01+ RX1 Address   : 0x%010llX\r\n", radio.getRxAddress(NRF24L01P_PIPE_P1) );

    frm = 0;
    while (1) {
        if(radio.readable(NRF24L01P_PIPE_P1)){
            frm = 1;
            int rx_bytes = radio.read(NRF24L01P_PIPE_P1, rxData, sizeof(rxData));
            uint8_t pdu_buffer[100] = {0};
            CoapPDU pdu(pdu_buffer+1, 99, 0);
            pdu.setVersion(1);
            pdu.setType(CoapPDU::COAP_NON_CONFIRMABLE);
            pdu.setCode(CoapPDU::COAP_POST);
            //pdu.setToken((uint8_t*)"\3\2\1\1",4);
            pdu.setToken(NULL,0);   // *maybe* can be empty, see rfc7252 section 5.3.1
            static uint16_t msgid = 0;  //TODO endian?
            pdu.setMessageID(msgid++);  //will overflow, that is okay (rfc again)

            std::string output = str_hex(rxData, rx_bytes);
            //wifi.printf("received: %s\r\n", output.c_str());
            //pc.printf("received: %s\r\n", output.c_str());
            Data d;
            d.deserialize(std::string(rxData, 32));
            std::stringstream ss;

            for (int i = 0; i < rx_bytes; ++i) {
                ss << std::hex << rxData[i] / 16 << rxData[i] % 16; // ugly!
            }
            pc.printf("received: %s|id %d |", ss.str().c_str(), d.type);
            //wifi.printf("received: %s, pkt:", ss.str().c_str());

            char uribuf[64] = {0};
            char pbuf[32] = {0};
            int psize = 0;
            switch(d.type) {
                case PIR1:
                    strcpy(uribuf, "pir1");
                    psize = sprintf(pbuf, "%d", d.value.i);
                    break;
                case PIR2:
                    strcpy(uribuf, "pir2");
                    psize = sprintf(pbuf, "%d", d.value.i);
                    break;
                case DISTANCE:
                    strcpy(uribuf, "distance");
                    psize = sprintf(pbuf, "%f", d.value.f);
                    break;
                case SOUND:
                    strcpy(uribuf, "volume");
                    psize = sprintf(pbuf, "%f", d.value.f);
                    break;
            }
            printf("URI %s V %s \r\n", uribuf, pbuf);
            pdu.setURI(uribuf,strlen(uribuf));

            pdu.setPayload((uint8_t*)pbuf, psize);
            frm = 0;
            //wait(0.1);
            //wifi.write((uint8_t*)test, sizeof(test), 0, 0);
            //uint8_t hdr[3] = {0x7e, 0, pdu.getPDULength()};
            //wifi.write(hdr, 3, 0, 0);
            wait(0.01);
            wifi.write(pdu_buffer, pdu.getPDULength()+1, 0, 0);
            //wait(0.1);
            //uint8_t end = 0xce;
            //wifi.write(&end, 1, 0, 0);
            wait(0.1);
            frm = 1;
            //wifi.printf("\n");
        }
    }
}
