#ifndef JNP3_COMMON_H
#define JNP3_COMMON_H

#include <sstream>
#include <stdint.h>
#include <string>
#include "nRF24L01P.h"
#include "mbed.h"

#define DATA_RATE       NRF24L01P_DATARATE_250_KBPS
#define POWER           NRF24L01P_TX_PWR_ZERO_DB
#define CHANNEL         2
#define TRANSFER_SIZE   32

const unsigned long long MASTER_ADDRESS = 0xBACDFF00;
const unsigned long long BOARD1_ADDRESS = 0xBACDFF01;
const unsigned long long BOARD2_ADDRESS = 0xBACDFF02;
const unsigned long long BOARD3_ADDRESS = 0xBACDFF03;

enum SENSOR_TYPE {
    PIR1 = 1,
    PIR2 = 2,
    DISTANCE = 3,
    SOUND = 4,
};

struct Data {
    Data(uint8_t type_, int32_t i_val)
        : type(type_) {
            value.i = i_val;
        }

    Data(uint8_t type_, float f_val)
        : type(type_) {
            value.f = f_val;
        }
    Data(): type(0)
    {
        value.i = 0;
    }

    std::string serialize();
    bool deserialize(std::string str);

    uint8_t type;
    union {
        int32_t i;
        float f;
    } value;
};

std::string str_hex(const char* text, int len);

void radio_init(nRF24L01P* radio, unsigned long long rx_address,
        unsigned long long tx_address);

#endif /* JNP3_COMMON */
