/* Blinky service application
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_BUTLED_SERVICE_H__
#define __BLE_BUTLED_SERVICE_H__

class Blinkyserv {
public:
    // These are stale UUIDs, not corresponding to Nordic
    //const static uint16_t LED_SERVICE_UUID = 0xA002;
    //const static uint16_t LED_STATE_CHARACTERISTIC_UUID = 0xA004;
    //const static uint16_t BUT_STATE_CHARACTERISTIC_UUID = 0xA005;

    // https://github.com/NordicSemiconductor/Android-nRF-Blinky/tree/master/app/src/main/java/no/nordicsemi/android/blinky/service/BlinkyManager.java
    // BaseUUID = {0x23, 0xd1, 0xbc, 0xea, 0x5f, 0x78, 0x23, 0x15, 0xde, 0xef, 0x12, 0x12, 0x23, 0x15, 0x00, 0x00};
    //const static UUID *LED_SERVICE_UUID = new UUID("00001523-1212-efde-1523-785feabcd123");
    //std::shared_ptr<UUID> LED_SERVICE_UUID;
    const UUID *LED_SERVICE_UUID;

    Blinkyserv(BLEDevice &_ble, bool initialValueForLEDCharacteristic, bool initialValueForButCharacteristic) :
        ble(_ble), ledState(UUID("00001525-1212-efde-1523-785feabcd123"), &initialValueForLEDCharacteristic),
        butState(UUID("00001524-1212-efde-1523-785feabcd123"), &initialValueForButCharacteristic, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        // Service definition logic
        GattCharacteristic *charTable[] = {&ledState, &butState};
        LED_SERVICE_UUID = new UUID("00001523-1212-efde-1523-785feabcd123");

        GattService GATTServ(static_cast<UUID>(*LED_SERVICE_UUID), charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(GATTServ);
    }

    // FIXME: Does this need a butState equivalent?
    GattAttribute::Handle_t getValueHandle() const {
        return ledState.getValueHandle();
    }

    void updateButtonState(bool newState) { // Sets button state characteristic appropriately
        //ble.gattServer().write(butState.getValueHandle(), (uint8_t *)&newState, sizeof(bool));
        ble.updateCharacteristicValue(butState.getValueHandle(), (uint8_t *)&newState, sizeof(bool));
    }

private:
    BLEDevice                         &ble;
    ReadWriteGattCharacteristic<bool>  ledState;
    ReadOnlyGattCharacteristic<bool>   butState;
    ~Blinkyserv() {
        delete LED_SERVICE_UUID;
    }
};

#endif /* #ifndef __BLE_BUTLED_SERVICE_H__ */