#include "mbed.h"
#include "pot.h"


Pot::Pot(PinName _pin, QEI* motor_encoder, float offset) : pend_angle(_pin),encoder() {
    encoder=motor_encoder;
    offset=offset;
    
}

void Pot::update(){
    //angular_velocity = (get_angle() - angle)/ UPDATE_TIME;
    angle=get_angle_pulse();
    //velocity = (get_position() - position) / UPDATE_TIME;   
    //position=get_position();
}
    
void Pot::set_zeros(){
    this->offset = (-1)*this->get_angle();
    this->encoder->reset();
    wait(2);
}

float Pot::get_angle(){
    float a = pend_angle.read() * VOLTAGE_ANGLE_RATIO + offset; 
    return a;  
}

float Pot::get_angle_pulse(){
    float b = (float) 360/ (float)1024;
    float a = ((float)encoder->getPulses()*b); 
    return a;  
}

float Pot::get_position(){
    float a = (-1)*encoder->getPulses()*CM_PER_PULSE; 
    return a;  
}

float Pot::angle_as_voltage(){
    float a = pend_angle.read(); 
    return a;  
}

int Pot::position_as_pulse(){
    return this->encoder->getPulses();  
}

void Pot::print_test(){
    printf("Position: %f \tVelocity: %f \tAngle: %f \tAngular Velocity: %f \r\n", position, velocity, angle, angular_velocity);     
}





