#ifndef MBED_POT_H
#define MBED_POT_H

#include "QEI.h"
#include "mbed.h"
 
class Pot {
public:
    Pot(PinName _pin, QEI* encoder, float offset);
    float get_angle();
    float angle_as_voltage();
    float get_angle_pulse();
    float get_position();
    int position_as_pulse();
    void set_zeros();
    void update();
    
    float angle;
    float position;
    float angular_velocity;
    float velocity; 
    void print_test();
    
    static const float UPDATE_TIME = 0.0001;
    

private: 
    AnalogIn pend_angle;
    QEI* encoder;
    float offset;
    
    //ecnoder conts
    static const float TOTAL_PULSES_ON_TRACK = 5700;
    static const float TRACK_LENGTH_CM = 400;
    static const float CM_PER_PULSE = TRACK_LENGTH_CM/TOTAL_PULSES_ON_TRACK;
    
    //pot const
    static const float VOLTAGE_ANGLE_RATIO = 327.76;
    
    //motor const
    static const int STEPS_PER_ROTATION = 1024;
     
    
};
 
#endif