#include "Motor.h"
#include "mbed.h"
  

Motor::Motor(PinName _M1PWM, PinName _M2PWM, PinName _M1DIR, PinName _M2DIR, PinName _D2, int default_delay) :    
                    M1PWM(_M1PWM),
                    M2PWM(_M2PWM), 
                    M1DIR(_M1DIR), 
                    M2DIR(_M2DIR),
                    D2(_D2){
    
    delay=default_delay;
    dir=true;    
    length = 5;
    
    M1PWM=0;
    M2PWM=0;
    M1DIR=0;
    M2DIR=0;
    D2=0;
    wait_us(10);
    D2=1; 
    steps = 0;   
}

void Motor::run(bool t){
    if(t){
        D2=1;
        if(dir) clockwise(delay);   
        else anticlockwise(delay);
    }else{
        D2=0;
    }     
}

void Motor::run2(bool t){
    if(t){
        D2=1;
        if(dir) step_clockwise(length, delay);   
        else step_anticlockwise(length, delay);
    }else{
        D2=0;
    }     
}

void Motor::initialize(int middle){
    step_clockwise(middle, 1000);
}

void Motor::anticlockwise(int delay){
    for (int i = 0; i < 8; i++) { 
        switch (i) { 
            case 0: {
                M1PWM=1;
                M1DIR=0;
                M2PWM=0;
                M2DIR=0;
            }
            break;
            case 1: {
                M1PWM=1;
                M1DIR=0;
                M2PWM=1;
                M2DIR=0;
            }
            break;
            case 2: {
                M1PWM=0;
                M1DIR=0;
                M2PWM=1;
                M2DIR=0;
            }
            break;
            case 3: {
                M1PWM=1;
                M1DIR=1;
                M2PWM=1;
                M2DIR=0;
            }
            break;
            case 4: {
                M1PWM=1;
                M1DIR=1;
                M2PWM=0;
                M2DIR=0;
            }
            break;
            case 5: {
                M1PWM=1;
                M1DIR=1;
                M2PWM=1;
                M2DIR=1;
            }
            break;
            case 6: {
                M1PWM=0;
                M1DIR=0;
                M2PWM=1;
                M2DIR=1;
            }
            break;
            case 7: {
                M1PWM=1;
                M1DIR=0;
                M2PWM=1;
                M2DIR=1;
            }
            break;
        }    
    wait_us(delay);
    }
    steps -= 1;
    //printf("%i\r\n",delay);     
}

void Motor::clockwise(int delay){
    for (int i = 0; i < 8; i++) { 
        switch (i) { // activate the ports A0, A2, A3, A3 in a binary sequence for steps
            case 0: {
                M1PWM=1;
                M1DIR=0;
                M2PWM=1;
                M2DIR=1;
            }
            break;
            case 1: {
                M1PWM=0;
                M1DIR=0;
                M2PWM=1;
                M2DIR=1;
            }
            break;
            case 2: {
                M1PWM=1;
                M1DIR=1;
                M2PWM=1;
                M2DIR=1;
            }
            break;
            case 3: {
                M1PWM=1;
                M1DIR=1;
                M2PWM=0;
                M2DIR=0;
            }
            break;
            case 4: {
                M1PWM=1;
                M1DIR=1;
                M2PWM=1;
                M2DIR=0;
            }
            break;
            case 5: {
                M1PWM=0;
                M1DIR=0;
                M2PWM=1;
                M2DIR=0;
            }
            break;
            case 6: {
                M1PWM=1;
                M1DIR=0;
                M2PWM=1;
                M2DIR=0;
            }
            break;
            case 7: {
                M1PWM=1;
                M1DIR=0;
                M2PWM=0;
                M2DIR=0;
            }
            break;
        }
        //printf("%i\r\n",delay);
        wait_us(delay);
    }
    steps += 1;
}

void Motor::anticlockwise(){
    anticlockwise(delay);
}
    
void Motor::clockwise(){
    clockwise(delay);
}

void Motor::step_clockwise(int steps){
    for (int i = 0; i < steps; i++){
        clockwise();
    }
} 

void Motor::step_anticlockwise(int steps){
    for (int i = 0; i < steps; i++){
        anticlockwise();
    }   
}

void Motor::step_clockwise(int steps, int delay){
    for (int i = 0; i < steps; i++){
        clockwise(delay);
    }
} 

void Motor::step_anticlockwise(int steps, int delay){
    for (int i = 0; i < steps; i++){
        anticlockwise(delay);
    }   
}
