//Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's MFRC522 library. Minimal changes
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too

//Connect as follows:
//RFID pins        ->  Nucleo header CN5 (Arduino-compatible header)
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10
//RFID RST=pin7    ->   Nucleo         =PA_9=D8
//3.3V and Gnd to the respective pins                              
                              
#include "mbed.h"
#include "MFRC522.h"

// Nucleo Pin for MFRC522 reset (pick another D pin if you need D8)
#define MF_RESET    D8


//Serial connection to PC for output
Serial pc(D1,D0);
//Serial master(PA_2,PA_3); //tx--rx

unsigned int sum_x = 0,RFID_Tag = 0;;
unsigned int p_flag = 0;

MFRC522    RfChip   (D11, D12, D13, D10, D8);

int main(void) {
  //pc.printf("starting...\n");
 // master.baud(115200);
  pc.baud(9600);
  // Init. RC522 Chip
  RfChip.PCD_Init();

  while (true) {

    // Look for new cards
    if ( ! RfChip.PICC_IsNewCardPresent())
    {
      if(p_flag == 0){RFID_Tag = 255;}
      //wait_ms(500);
     //RFID_Tag = 255;
      pc.putc(RFID_Tag);
   pc.putc('\n');
  //pc.printf("%d\n",RFID_Tag);
     // pc.printf("RFID_Tag : %d",RFID_Tag);
     p_flag = 0;
      continue;
    }
    
    // Select one of the cards
    if ( ! RfChip.PICC_ReadCardSerial())
    {
      if(p_flag == 0){RFID_Tag = 255;}
      //wait_ms(500);
      pc.putc(RFID_Tag);
   pc.putc('\n');
     //RFID_Tag = 255;
     //pc.printf("%d\n",RFID_Tag);
      //pc.printf("RFID_Tag : %d",RFID_Tag);
      p_flag = 0;
      continue;
    }


    // Print Card UID
    //pc.printf("Card UID: ");
    for (uint8_t i = 0; i < RfChip.uid.size; i++)
    {
      sum_x += RfChip.uid.uidByte[i];
    }
    if(sum_x == 461)RFID_Tag = 1;
    else if(sum_x == 538)RFID_Tag = 2;
    else if(sum_x == 598)RFID_Tag = 3;
    else if(sum_x == 548)RFID_Tag = 4;
    else if(sum_x == 460)RFID_Tag = 5;
    else if(sum_x == 641)RFID_Tag = 6;
    else if(sum_x == 468)RFID_Tag = 7;
    else if(sum_x == 490)RFID_Tag = 8;
    else if(sum_x == 355)RFID_Tag = 9;
    else if(sum_x == 542)RFID_Tag = 10;
    else if(sum_x == 624)RFID_Tag = 11;
    else if(sum_x == 480)RFID_Tag = 12;
    else if(sum_x == 489)RFID_Tag = 13;
    else if(sum_x == 506)RFID_Tag = 14;
    else if(sum_x == 584)RFID_Tag = 15;
    else if(sum_x == 698)RFID_Tag = 16;
    else if(sum_x == 399)RFID_Tag = 17;
    else if(sum_x == 546)RFID_Tag = 18;
    else if(sum_x == 459)RFID_Tag = 19;
    else if(sum_x == 517)RFID_Tag = 20;
    else if(sum_x == 358)RFID_Tag = 21;
    else if(sum_x == 567)RFID_Tag = 22;
    else if(sum_x == 397)RFID_Tag = 23;
    else if(sum_x == 564)RFID_Tag = 24;
    else if(sum_x == 361)RFID_Tag = 25;
    else RFID_Tag = 255;
    p_flag = 1;
    
    //pc.printf("%d\n",RFID_Tag);
    
   pc.putc(RFID_Tag);
   pc.putc('\n');
    
    sum_x = 0;

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    //pc.printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    //wait_ms(1000);
  }
}