#include "mbed.h"
#include "MMA8451Q.h"
#include "TSISensor.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)

DigitalOut myled(LED_GREEN);
Serial serial(USBTX,USBRX);
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
TSISensor tsi;

int main() {

    int i=0;
    
    while (true) {
        //wait(0.5);
        serial.printf("{\"i\":%d,\"x\":%5.2f,\"y\":%5.2f,\"z\":%5.2f, \"tsi\":%5.2f}\n",
            i, acc.getAccX(), acc.getAccY(), acc.getAccZ(), tsi.readPercentage());
        i++;
        myled = !myled;
    }
}
