/**
 * @4_Project
 * @author  Alfie Mowle <19703361@students.lincoln.ac.uk>
 * @version 1.4
 *
 * Touch-based Health Assistive Device
 * 
 * The device is a control panel that will be used by people with limited 
 * mobility to change certain things such as room temperature, alert assistance
 * and a night light. With the components I have the control panel will turn on
 * lights instead to indicate they have received the signal. This is also 
 * intentionally done for people with limited visibility.
 */
 
#include "mbed.h"
#include "MPR121.h"

DigitalOut myrled(PTD0);    //Sends a bus out to LEDs
DigitalOut mygled(PTD2);
DigitalOut mybled(PTD1);
DigitalOut mywled(PTC4);
I2C i2c(D14, D15);  //Sends bus out to Touch Sensors
MPR121 touch_pad(i2c, MPR121::ADDR_VSS);

int main()
{
    uint16_t button_val = 0;    //Sets button value to off
    touch_pad.init();   //Clears variables and initializes dependant objects
    touch_pad.enable(); //Runs IC and senses user input

    myrled = 0; //Set all LEDs to off
    mygled = 0;
    mybled = 0;
    mywled = 0;

    while(button_val != 0xf) {
        button_val = touch_pad.buttonPressed(); //Sets value to state of buttons
        printf("button = 0x%04x\n", button_val);
        wait(0.2);
    }

    myrled = 1; //Flash all LEDs
    mygled = 1;
    mybled = 1;
    mywled = 1;
    wait(0.5);
    myrled = 0;
    mygled = 0;
    mybled = 0;
    mywled = 0;

    while(1) {
        button_val = touch_pad.buttonPressed(); //Sets value to state of buttons
        printf("button = 0x%04x\n", button_val);    //Prints value in terminal
        wait(0.2);

        if(button_val == 1 ) { //If value is 1 turn red LED on (heat)
            myrled = 1;
            mybled = 0;
            wait(0.2);
        }
        if(button_val == 2) { //If value is 2 turn green LED on (night light)
            mygled = 1;
            wait(0.2);
        }
        if(button_val == 4) { //If value is 4 turn blue LED on (cool)
            mybled = 1;
            myrled = 0;
            wait(0.2);
        }
        if(button_val == 8) { //If value is 8 turn white LED on (nurse)
            mywled = 1;
            wait(0.2);
        }
        if(button_val == 0xf) { //If all buttons press turn off LEDs
            myrled = 0;
            mygled = 0;
            mybled = 0;
            mywled = 0;
        }
    }
}
