#include "mbed.h"
#include <string>
#include "Adafruit_LEDBackpack.h"
#include "Adafruit_GFX.h"
#include "TextLCD.h"
#include "DebounceIn.h"
#include "cc3000.h"
#include "Websocket.h"

//Debug
Serial pc(USBTX, USBRX); // tx, rx

//For oscilliscope
Timer timer;

//LED stuff
I2C i2c_left(PTC11,PTC10);
Adafruit_24bargraph ledbar_left=Adafruit_24bargraph(&i2c_left);

I2C i2c_right(D7,D6);
Adafruit_24bargraph ledbar_right=Adafruit_24bargraph(&i2c_right);

void set_led(int index, int color) { // index range from 0-47
    if (index<24) {
        ledbar_left.setBar(index,color);
    } else {
        ledbar_right.setBar(index-24,color);
    }
}

DebounceIn upbutton(PTA16);
DebounceIn downbutton(PTC12);
DebounceIn leftbutton(PTC17);
DebounceIn rightbutton(PTC16);

//Scanner stuff

DebounceIn scanbutton(PTC13);
//DebounceIn scanbutton(D7);

DigitalOut A_in(PTB10);
DigitalOut B_in(PTB11);
DigitalOut C_in(PTE2);
DigitalOut D_in(PTE3);
DigitalOut E_in(PTE4);
DigitalOut F_in(PTE5);

DigitalOut scan_select(PTC3);

AnalogIn  adc(PTB0);
AnalogOut dac(PTE30);



//LCD stuff
//TextLCD(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7, LCDType type = LCD16x2);
TextLCD lcd(PTC6,PTC5,D5,D4,D3,D2,TextLCD::LCD20x4);

void lcd_write_selected_info(int selected) {
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("The ToastBoard");
    lcd.locate(0,1);
    lcd.printf("Selected row: %d",selected);
}

void lcd_write_voltage_info(float vddval,int selected,float rowval) {
    lcd.cls();
    lcd.locate(0,1);
    lcd.printf("Vdd: %1.2f V",vddval);
    lcd.locate(0,0);
    lcd.printf("Row %d: %1.2f V",selected,rowval);
}


//WIFI STUFF


// cc3000 KL25Z wifi connection
// we need to define connection pins for:
// - IRQ      => (pin D3)
// - Enable   => (pin D5)
// - SPI CS   => (pin D10)
// - SPI MOSI => (pin D11)
// - SPI MISO => (pin D12)
// - SPI CLK  => (pin D13)
// plus wifi network SSID, password, security level and smart-configuration flag.



mbed_cc3000::cc3000 wifi(D8, D9, D10, SPI(D11, D12, D13), // spi goes mosi, miso, clk
                        "EECS-PSK", "Thequickbrown", WPA2, false);
Websocket ws("ws://sockets.mbed.org/ws/toastboard/rw");


void add_to_json(const std::string& s, std::back_insert_iterator<std::string> oi) {
    // this chunk of code lifted from the MbedJSONValue 
    char buf[7];
    for (std::string::const_iterator i = s.begin(); i != s.end(); ++i) {
        if ((unsigned char)*i < 0x20 || *i == 0x7f) {
            sprintf(buf, "\\u%04x", *i & 0xff);
            copy(buf, buf + 6, oi);
        } else {
            *oi++ = *i;
        }
    }
}

std::string build_json(float vddval,int selected,float clientdata[48]) {
    std::string s;
    std::back_insert_iterator<std::string> json_str = std::back_inserter(s);
    char row[1] = ""; // holder for row tokens
    char rowvoltage[4] = ""; // holder for voltage values
    add_to_json("{\"vddval\":",json_str);
    sprintf(rowvoltage,"%.1f",vddval*3.3);
    add_to_json(rowvoltage,json_str);
    add_to_json(", \"selected\":",json_str);
    sprintf(row,"%d",selected);
    add_to_json(row,json_str);
    add_to_json(", \"rows\": [",json_str);
    int append_comma = 0;
    for (int i= 0; i < 48; i++) {
        if (clientdata[i] != 100.0) { // don't pass on floating row vals
            if (append_comma == 1) {
                add_to_json(",",json_str);
            } else {
                append_comma = 1;
            }
            add_to_json("{\"",json_str);
            sprintf(row, "%d", i);
            add_to_json(row,json_str);
            add_to_json("\":",json_str);
            sprintf(rowvoltage,"%.1f",clientdata[i]*3.3);
            add_to_json(rowvoltage,json_str);
            add_to_json("}",json_str);
        }
    }
    add_to_json("]}",json_str);
    return s;
}



bool voltages_equal(float voltage1,float voltage2) {
    return (voltage1 > voltage2-0.005) && (voltage1 < voltage2+0.005);
}

void read_voltages(float voltages[48]) {
    float voltbuffer[48] = {};
    scan_select = 0;
    int sn = 0;
    for (int i=0;i<48;i++) {
            sn = i; 
            D_in = (sn)%2;
            E_in = ((sn)/2)%2;
            F_in = ((sn)/4)%2;
            A_in = ((sn)/8)%2;
            B_in = ((sn)/16)%2;
            C_in = ((sn)/32)%2;
            
            for (int j=0;j<10;j++) {
            wait(0.0025);
            voltbuffer[sn] = (adc.read()/10) + voltbuffer[sn];
            }
            voltages[sn] = voltbuffer[sn]; 
    }
}

void float_check(float voltages[48],float dacval) {
    int sn = 0;
    for (int i=0;i<48;i++) { // iterate over two columns of breadboard
        // iterate over 24 rows of each column
            sn = i; 
            D_in = (sn)%2;
            E_in = ((sn)/2)%2;
            F_in = ((sn)/4)%2;
            A_in = ((sn)/8)%2;
            B_in = ((sn)/16)%2;
            C_in = ((sn)/32)%2;
            
            scan_select = 1;
            scan_select = 0;
            wait(0.02);
            float in_val = adc.read();
            voltages[sn] = in_val;
            
            wait(0.035);
            
            scan_select = 1;
            scan_select = 0;
            wait(0.02);
            in_val = adc.read();
   
            
            if ((in_val < voltages[sn]-0.008) || (in_val > voltages[sn]+0.008)){
                voltages[sn] = 100.0;
            
            }
            
        
    }
}



void compare_voltages(float voltages[48], float clientdata[48], int colselect, int rowselect, float vddval, float floatchecked[48], float newvoltages[48]) {
    // get selected row voltage
    float voltbuffer[48] = {};
    scan_select = 0;
    float rowval = voltages[(colselect*24)+ rowselect];
    for (int i=0;i<48;i++) {
        int sn = i;//(colselect+1)*(rowselect+1); 
        D_in = (sn)%2;
        E_in = ((sn)/2)%2;
        F_in = ((sn)/4)%2;
        A_in = ((sn)/8)%2;
        B_in = ((sn)/16)%2;
        C_in = ((sn)/32)%2;
        
         for (int j=0;j<10;j++) {
            wait(0.0025);
            voltbuffer[sn] = (adc.read()/10) + voltbuffer[sn];
            }
        newvoltages[sn] = voltbuffer[sn]; 
        
    //    float in_val = adc.read();
    //    newvoltages[i] = in_val;
        
        if (floatchecked[sn] == 100){
            set_led(i,LED_OFF);
            clientdata[i] = 100.0;
            }
        else {    
        
        
        if (!voltages_equal(voltages[i],newvoltages[sn])) {
            // this row is floating
            set_led(i,LED_OFF);
            clientdata[i] = 100.0;
        } else if (voltages_equal(voltages[i],vddval) || voltages_equal(newvoltages[i],vddval)) {
            // this row matches vdd
            set_led(i,LED_RED);
            clientdata[i] = vddval;
        } else if (voltages_equal(voltages[i],0.0) || voltages_equal(newvoltages[i],0.0)) {
            // this row matches ground
            set_led(i,LED_YELLOW);
            clientdata[i] = 0.0;
        } else if (voltages_equal(voltages[i],rowval) || voltages_equal(newvoltages[i],rowval)) {
            // this row matches selected row
            set_led(i,LED_GREEN);
            clientdata[i] = rowval;
        } else {
            set_led(i,LED_OFF);
            clientdata[i] = voltages[i];
        }
        } // else if closing
    } //for loop closing
 } //compare_voltages function closing


int main()
{

    //Scan init
    float originalvoltages[48] = {};
    float newvoltages[48] = {};

    float clientdata[48] = {};
    float vddval = 0.0;
    float rowval = 0.0;
    float dacval = 0.1;
    
    float floatout[48] = {};

    //LED init
    int rowselect = 0, moved = 1, colselect = 0, selected = 0, oldselected = 49;
    ledbar_left.begin(0x70);
    ledbar_left.clear();
    ledbar_left.writeDisplay();

    ledbar_right.begin(0x70);
    ledbar_right.clear();
    ledbar_right.writeDisplay();

    //LCD init
    lcd.cls();
    int written = 0;

    wifi.init();
    char * writable;

    //Osci
    int loopcount = 0, pressed = 0;
    float begintime = 0, endtime = 0, elapsed = 0;
    
    int datatosend = 0;



    while(1) {
             if (wifi.is_connected() == false) {
                pc.printf("trying to connect to v\r\n");
                if (wifi.connect() == -1) {
                    pc.printf("Failed to connect\r\n");
                } else {
                    pc.printf("IP address: %s \r\n", wifi.getIPAddress());
                }
            } else {
                if (datatosend) {
                    pc.printf("json in queue to be sent out\r\n");
                    Websocket ws("ws://sockets.mbed.org/ws/toastboard/rw");
                    ws.connect();
                    if (ws.send(writable) != -1) {
                        datatosend = 0;
                        pc.printf("we have sent a message!\r\n");
                        delete writable;
                    }
                }

            }

       
        
        //Display
        if (moved ==1) {
            ledbar_left.clear();
            ledbar_right.clear();
            set_led((colselect*24+rowselect),LED_GREEN);
            ledbar_left.writeDisplay();
            ledbar_right.writeDisplay();
        }
        //Moving the selected row
        if (upbutton.read() == 0) {
            rowselect = rowselect-1;
            moved = 1;
            written = 0;
            pc.printf("moved up\r\n");
            wait(0.3);
        }

        if (downbutton.read() == 0) {
            rowselect = rowselect+1;
            moved = 1;
            written = 0;
            pc.printf("moved down\r\n");
            wait(0.3);
        }

        if (leftbutton.read() == 0) {
            colselect = 0;
            ledbar_right.clear();
            moved =1;
            written = 0;
            pc.printf("moved left\r\n");
            wait(0.3);
        }

        if (rightbutton.read() == 0) {
            colselect = 1;
            ledbar_left.clear();
            moved =1;
            written = 0;
            pc.printf("moved right\r\n");
            wait(0.3);
        }

        //Boundary checking
        if (rowselect > 23) {
            rowselect = 23;
        }
        if (rowselect < 0) {
            rowselect = 0;
        }

        selected = (colselect * 24) + (rowselect+1);
     //   pc.printf("selected is %d\r\n",selected);
        
        //Implementing scanning

        if (scanbutton.read() == 0) {
            
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Scanning....");
            
            float vddbuff = 0;
            A_in = 0;
            B_in = 1;
            C_in = 1;
            D_in = 1;
            E_in = 0;
            F_in = 0;

            for (int j=0;j<10;j++) {
            wait(0.0025);
            vddbuff = (adc.read()/10) + vddbuff;
            }
            vddval = vddbuff; 
           
            
            

            ledbar_left.clear();
            ledbar_right.clear();

            // first set of voltages read into old_volt_mat
            
            //float_check(floatout,dacval);
            wait(0.2);
            read_voltages(originalvoltages);
            // second set for comparison, read into clientdata
            wait(0.2);
            compare_voltages(originalvoltages,clientdata,colselect,rowselect,vddval,floatout,newvoltages);
        
           

            selected = (colselect * 24) + (rowselect+1);
            rowval = originalvoltages[selected-1];

            written = 0;
            moved = 0;

                //DEBUGGING TOOLS //////////////

            pc.printf("\r\n%1.3f %1.3f \r\n", vddval, rowval);
            for (int i = 0; i<48; i++) {
                pc.printf(" %1.4f ", clientdata[i]);
            }
            pc.printf(" \r\n \r\n ");
            for (int x = 0; x < 48; x++) {
                    pc.printf("%1.4f  %1.4f  %d  \r\n", originalvoltages[x], newvoltages[x], x+1);
            }
            ////////////////////////


          //THIS NEEDS TO GO AWAY! 

            } // END OF SCANBUTTON IF STATEMENT

            if (moved==0 && written == 0)  {
                ledbar_left.writeDisplay();
                ledbar_right.writeDisplay();
                lcd_write_voltage_info(vddval*3.3,selected,rowval*3.3);
                
                
                // send data to websocket
                datatosend = 1;
                std::string json = build_json(vddval,selected,clientdata);
               // delete writable;
                writable = new char[json.size() + 1];
                std::copy(json.begin(), json.end(), writable);
                writable[json.size()] = '\0';
                pc.printf(writable);
                pc.printf("\r\n");

                
                
                written = 1;
            } else if (oldselected != selected) {
                lcd_write_selected_info(selected);
                
            }
            oldselected = selected;












        }  // END OF WHILE(1)




    }  // END OF INT MAIN


    /*
    OSCILLISCOPE


    while (scanbutton == 0){
    if (loopcount = 0){
    timer.reset();
    timer.start();
    begintime = timer.read_ms();
    pressed == 1;
    }

    int sn = (colselect + 1)*(rowselect + 1);
                A_in = (sn-1)&2;
                B_in = ((sn-1)/2)%2;
                C_in = ((sn-1)/4)%2;
                D_in = ((sn-1)/8)%2;
                E_in = ((sn-1)/16)%2;
                F_in = ((sn-1)/32)%2;
                volt_buffer[loopcount] = adc.read();


    loopcount = loopcount +1;
    } // BREAK THE WHILE SCANBUTTON

    if (pressed == 1){
    timer.stop();
    endtime = timer.read_ms();
    elapsed = endtime - begintime;

    DO ENTIRE SCAN STUFF

    pressed = 0;
    }

    */