#include "mbed.h"
 
//serial connection to PC via USB
Serial pc(USBTX, USBRX);
AnalogIn strut1Force(P0_1);
AnalogIn strut2Force(P0_2);
AnalogIn strut3Force(P0_3);
AnalogIn strut4Force(P0_4);
AnalogIn seatForce(P0_5);
AnalogIn cupBottomForce(P0_6);

DigitalOut light(LED1);
 
int main(void)
{ 
pc.printf("init\n");
    while (true) {
        //pc.printf("test");
        //light = 1;
        float vals[6] = { strut1Force.read(), strut2Force.read(), strut3Force.read(), strut4Force.read(), seatForce.read(), cupBottomForce.read() };
        pc.printf("%1.2f,%1.2f,%1.2f,%1.2f,%1.2f,%1.2f\n", vals[0], vals[1], vals[2], vals[3], vals[4], vals[5]);
        wait(0.001f); // wait 50ms (200Hz update rate)
        //light = 0;
    }
    
}
/* // Sensor graphing sketch with threshold
// This program takes ASCII-encoded strings
// from the serial port at 9600 baud and graphs them. It expects float values in the
// range of -1.0 to 1.0, followed by a newline, or newline and carriage return

// based on Tom Igoe's Arduino sensor graphing sketch, created 20 Apr 2005
// Adapted 16 Sep 2014 by Bjoern Hartmann for mbed
// This example code is in the public domain.

import processing.serial.*;
import java.util.Scanner;

Serial myPort;        // The serial port
int xPos = 1;         // horizontal position of the graph
float threshold=0.3;
float minThreshold = 0.1;
float max = 0;
boolean rise = true;
PImage bearImg;

void setup () {
  // set the window size:
  //size(400, 300);          
  //fullscreen
  size(displayWidth, displayHeight);
  // List all the available serial ports to help you find the one you need
  println(Serial.list());
  // Open whatever port is the one you're using.
  myPort = new Serial(this, "/dev/tty.usbmodem1422", 9600);
  // don't generate a serialEvent() unless you get a newline character:
  myPort.bufferUntil('\n');
  // set inital background:
  redrawBG();
  
  bearImg = loadImage("cal_bear.png");
}

void draw () {

  // everything happens in the serialEvent()
}

void keyPressed() {
if (key == CODED) {
    if (keyCode == UP) {
      threshold+=0.05;
    } else if (keyCode == DOWN) {
      threshold-=0.05;
    } 
    redrawBG();  
  }
}

// threshold 0.2 - 0.9

void serialEvent (Serial myPort) {
  // get the ASCII string:
  
  String inString = myPort.readStringUntil('\n');

  if (inString != null) {
    Scanner scanner = new Scanner(inString);
    
    // trim off any whitespace:
    inString = trim(inString);
    // convert to an int and map to the screen height:
    float inFloat =0.f;
    try{
     inFloat = scanner.nextFloat();//float(inString);
    } catch (Exception e) {
      print(e);
    }
    
    
  if(rise) {  // we were last below
    if(inFloat>threshold) { // we're above where we want to be
      // rising edge, becoming true
      rise = false;
      drawHit(inFloat);

    } // else // do nothing
        
  } else { // below == false, above threshold
    if(inFloat < threshold) { //we drop below threshold
      rise = true;
      delay(500);
      redrawBG();
      max = 0;
    } else  // below == false, still above threshold
      drawHit(inFloat);
    }
    

    // at the edge of the screen, go back to the beginning:
  }
}

void drawHit(float inFloat) {
        if(max < inFloat) {
        max = inFloat;
        float screenY = map(inFloat, 1.0, 0, 0, height);
        
        redrawBG();
        // draw the line from bottom of screen to desired height
        // choose color based on side of threshold we're on
        float texty = map(threshold,0,1,height,0);
        int percent = round(inFloat*100);
        String hitText = "";
        if(inFloat<threshold) {
          fill(61,126,155);
          hitText = "LAME"; 
        } else {
          hitText = percent + "%";
          fill(231,76,70);
        }
        //println(inFloat);
        textSize(72);
        text(hitText,20,texty-40);
        rect(width/2-20 , height, 40, -1*(height - screenY));
      }
}

void redrawBG() {
      background(236,240,241);
      stroke(52,73,94);
      float ty = height-map(threshold,0,1,0,height);
      line(0,ty,width,ty);
      fill(255,0,0);
      stroke(0,0,0);
      textSize(100);
      text("Test your strength!",width/5.7,100);
}
*/
 