#include "mbed.h"
#include "USBKeyboard.h"
#include  "USBHID.h"

USBKeyboard keyboard;
//x y and z accelerometer inputs
AnalogIn z(A0);
AnalogIn y(A1);
AnalogIn x(A2);

HID_REPORT report;
Timeout endJump;

bool inJump = false;
bool stopJump = false;
 
//sends report to end pressing 'z' for jump
void finishJump(){
    stopJump = true;
}

int main() {
    //report to press and release keys
    report.data[0] = 1; 
    report.data[1] = 0; 
    report.data[3] = 0; // 'z'
    report.data[4] = 0; //left
    report.data[5] = 0; //right
    report.data[6] = 0; //'x'
    report.length = 9;

    int direction = 0; //0 is stationary, 1 is left, 2 is right
    int speed = 0; //0 is stationary or walking, 1 is running
    
    while(1) {

        //stop the jump if the timeout has gone
        if(stopJump){
            stopJump = false;
            inJump = false;
            report.data[3] = 0;
            keyboard.send(&report);    
        }
        
        //check for a jump
        if(y.read() > 0.50 && !inJump) {
            inJump = true;
            float highesty = 0.50;
            
            //wait until obtaining highest y to know magnitude of jump
            float newy = y.read();
            while(newy > 0.50){
                if (newy > highesty) highesty = newy;
                newy = y.read();
            }
            
            //start regular jump if highest y < 0.6
            if(highesty < 0.6){
                report.data[3] = 0x1D; //'z'
                keyboard.send(&report);
                endJump.attach(&finishJump, 0.1);
            } else {
                //start high jump otherwise
                report.data[3] = 0x1D; //'z'
                keyboard.send(&report);
                endJump.attach(&finishJump, 0.8);
            }
        }
        
        //check for tilt forward or back
        float newx = x.read();
        if(newx > 0.52 && direction != 2){
            //start moving forward
            direction = 2;
            report.data[4] = 0; 
            report.data[5] = 0x4F; //right
            keyboard.send(&report);
        } else if(newx < 0.47 && direction != 1){
            //start moving back
            direction = 1;
            report.data[4] = 0x50; //left
            report.data[5] = 0;
            keyboard.send(&report);
        } else if((newx < 0.51  && direction == 2) || (newx > 0.48 && direction == 1)){
            //stop movement
            direction = 0;
            report.data[4] = 0;
            report.data[5] = 0;
            keyboard.send(&report);
        }
        
        //check if mario is running
        if((newx > 0.55 || newx < 0.44) && speed == 0){
            //press x to start running
            speed = 1;
            report.data[6] = 0x1B;
            keyboard.send(&report); 
            pc.printf("start\n\r");
        } else if (newx > 0.47 && newx < 0.52 && speed == 1){
            //release x to stop running
            speed = 0;
            report.data[6] = 0;
            keyboard.send(&report); 
            pc.printf("stop\n\r");   
        }

    }
}