#include "mbed.h"
#include "BLEDevice.h"
#include <string>
#include "UARTService.h"
 
#define NEED_CONSOLE_OUTPUT 1 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */
Serial pc(USBTX, USBRX);

#if NEED_CONSOLE_OUTPUT
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */
 
BLEDevice  ble;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
 
AnalogIn strut1Force(P0_1);
AnalogIn strut2Force(P0_2);
AnalogIn strut3Force(P0_3);
AnalogIn strut4Force(P0_4);
AnalogIn seatForce(P0_5);
AnalogIn cupBottomForce(P0_6);
AnalogIn sensors[6] = {strut1Force, strut2Force, strut3Force, strut4Force, seatForce, cupBottomForce};

static volatile bool  triggerSensorPolling = false;

float sensorValues[6];
 
char buffer[6];
 
UARTService *uartServicePtr;
 
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}
 
 
void onDataWritten(const GattCharacteristicWriteCBParams *params)
{
    //doSomething
    /*
    if ((uartServicePtr != NULL) && (params->charHandle == uartServicePtr->getTXCharacteristicHandle())) {
        uint16_t bytesRead = params->len;
        DEBUG("received %u bytes\n\r", bytesRead);
        DEBUG("first byte received: %u\n\r", params->data[0]);
        if (params->data[0] == '1') {
            led2 = 1;
            powerSwitch = 1;
        } else if (params->data[0] == '0') {
            led2 = 0;
            powerSwitch = 0;
        }
        char buffer[4];
        DEBUG("%1.2f,%1.2f,%1.2f,%1.2f,%1.2f,%1.2f\n", strut1Force.read(), strut2Force.read(), strut3Force.read(), strut4Force.read(), seatForce.read(), cupBottomForce.read());
//        sprintf(buffer, "%1.2f,%1.2f,%1.2f,%1.2f\n", strut1Force.read(), strut2Force.read(), strut3Force.read(), strut4Force.read());
        //ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), (uint8_t *)buffer, sizeof(&buffer));
        for(int i=0; i <= 5; i++) 
        {
            sprintf(buffer, "%1.2f\n", sensors[i].read());
            ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), (uint8_t *)buffer, sizeof(&buffer));
        }
    }
    */
}
 
void periodicCallback(void)
{
    led1 = !led1;
    triggerSensorPolling = true;
}
 
int main(void)
{
    
    led1 = 1;
    led2 = 0;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
 
    DEBUG("Initialising the nRF51822\n\r");
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten); // called when someone writes to me
 
    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"pgao", sizeof("pgao") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));
 
    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();
 
    UARTService uartService(ble);
    uartServicePtr = &uartService;
 
    while (true) {
        if(triggerSensorPolling /*&& ble.getGapState().connected*/ && uartServicePtr != NULL) {
            triggerSensorPolling = false; 
            
            for(int i = 0; i < 6; i++) {
                sensorValues[i] = sensors[i].read()*100;
                if(sensorValues[i] == 100) sensorValues[i] = 99;
            
                sprintf(buffer, "%d%2.0f", i,sensorValues[i]);
                ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), (uint8_t *)buffer, sizeof(&buffer));
            }
            DEBUG("trying to write values:\n%1.2f,%1.2f,%1.2f,%1.2f,%1.2f,%1.2f\n", strut1Force.read(), strut2Force.read(), strut3Force.read(), strut4Force.read(), seatForce.read(), cupBottomForce.read());

            // do something
        }
        ble.waitForEvent();
    }
}
 
 