//THE INFAMOUS NET TRAP
//Brought to you by Team LaTe


#include "mbed.h"
#include "TB6612.h"
#include "nRF8001.h"
#include "BLEPeripheral.h"
#include "BLECharacteristic.h"

//Init
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Serial serial(USBTX, USBRX); // tx, rx

//BLE breakout
SPI spi(D11, D12, D13);
DigitalInOut req(PTD0); // D10
DigitalInOut rdy(PTD4); // D2 needs a different pin
DigitalInOut rst(PTD5); // D9

//Motor driver
DigitalOut BIN2(D3);
DigitalOut BIN1(D4);
PwmOut PWMB(D6);
DigitalOut stdby(D14);
TB6612 motorB(D6,D3,D4);    // PWMA,AIN1,AIN2

//Ultrasonic
float distance = 0;
float raw = 0;
int dropped = 0;
DigitalOut ultra_trigger(D8);
AnalogIn ultra_out(A0);

BLEProperty read = BLERead;
BLEProperty write = BLEWrite;
BLEProperty notify = BLENotify;

BLEPeripheral blePeripheral = BLEPeripheral(&req,&rdy,&rst);
BLEService service = BLEService("5794ba16-ce64-46e5-9804-6851f7b3a183");
BLECharacteristic netDropChrc = BLECharacteristic("fbb3136a-fe49-445b-a612-2019d1b33a6c",read | write,1,1);
BLECharacteristic netDisarmedChrc = BLECharacteristic("f80fb006-0e8e-412c-8a92-19fe85328daa",read | write | notify,1,1);

int main()
{
    serial.printf("starting something\r\n");
    led1 = 1;
    led2 = 1;
    led3 = 1;

    ultra_trigger = 1;
    motorB = 0.0;
    stdby = 1;
    
    blePeripheral.setLocalName("NETTRAP");
    blePeripheral.setDeviceName("net trap peripheral!");
    blePeripheral.setAdvertisedServiceUuid(service.uuid());
    blePeripheral.addAttribute(service);
    serial.printf("set up attributes and so on \r\n");
    blePeripheral.addAttribute(netDropChrc);
    blePeripheral.addAttribute(netDisarmedChrc);
    serial.printf("added characteristics\r\n");

    char* bufTrue = "t";
    char* bufFalse = "f";
    netDropChrc.setValue(bufFalse);
    netDisarmedChrc.setValue(bufFalse);
    serial.printf("set up characteristic values\r\n");

    blePeripheral.begin();
    serial.printf("began peripheral supposedly\r\n");
    
    
    
    while(true) {

        
        if (*netDropChrc.value() == 'f') {
            if (*netDisarmedChrc.value()== 't') {
            dropped = 1; 
            }
            else {
            dropped = 0;
            }
        }
        
        else {
            dropped = 1;
            }
     
        blePeripheral.poll();
        motorB = 0.0;
        raw = ultra_out;
        distance = (ultra_out * 5) / 0.0098 ;
        serial.printf("%1.3f %1.3f \n", raw, distance);
        if (distance < 20 && dropped == 0) {
            motorB = 1.0;
            netDropChrc.setValue(bufTrue);
            dropped = 1;
        }
        wait(1);
    }

}







