#include "mbed.h"
#include "MMA8451Q.h"
#include "USBMouse.h"

USBMouse mouse;

// define I2C Pins and address for KL25Z. Taken from default sample code.
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#define MMA8451_I2C_ADDRESS (0x1d<<1)

//serial connection to PC via USB
Serial pc(USBTX, USBRX);

DigitalIn button1(D8);
DigitalIn button2(D7);

int main(void)
{
    AnalogIn xPin(A3);
    AnalogIn yPin(A4);
    AnalogIn zPin(A5);
    button1.mode(PullUp);
    button2.mode(PullUp);
    
    //configure on-board I2C accelerometer on KL25Z
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    
    Serial pc(USBTX, USBRX);
    
    while (true) {
        
        float xValue = xPin.read();
        float yValue = yPin.read();
        float zValue = zPin.read();
        pc.printf("%1.2f, %1.2f, %1.2f \r\n", xValue - 0.5, yValue - 0.48, zValue);
        mouse.move(-150 * (xValue - 0.5), 150 * (yValue - 0.48));
        
        if (!button1) {
            mouse.click(MOUSE_LEFT);
            wait(1);
        }
        if (!button2) {
            
            float yValueMax = yPin.read();
            yValue = yPin.read();
            while(true){
                if (yValue > yValueMax){
                    yValueMax = yValue;
                    yValue = yPin.read();
                } else if ((yValue + .30) <= yValueMax){
                    mouse.click(MOUSE_LEFT);
                    break;   
                } else {
                    yValue = yPin.read();
                }
            }
            /*while(true){
                if (yValue <= .50){
                    yValue = yPin.read();
                } else {
                    while(true){
                        yValue = yPin.read();
                        if (yValue < .40){
                            mouse.click(MOUSE_LEFT);
                            break;
                        }
                    }
                }
                break;
            }*/
        }
    }
}

/*
// Graphing sketch for Processing


// This program takes ASCII-encoded strings containing floating point numbers
// from the serial port at 9600 baud and graphs them. It expects values in the
// range -1.0 to 1.0, followed by a newline, or newline and carriage return

// Created 20 Apr 2005
// Updated 18 Jan 2008 by Tom Igoe
// Adapted 16 Sep 2014 by Bjoern Hartmann for mbed
// This example code is in the public domain.

import processing.serial.*;

Serial myPort;        // The serial port
int xPos = 1;         // horizontal position of the graph

float minVal=-1.0;
float maxVal=1.0;

void setup () {
  // set the window size:
  size(400, 300);        

  // List all the available serial ports
  println(Serial.list());
  // Open whatever port is the one you're using.
  myPort = new Serial(this, "/dev/tty.usbmodem1412", 9600);
  // don't generate a serialEvent() unless you get a newline character:
  myPort.bufferUntil('\n');
  // set inital background:
  background(0);
}
void draw () {
  // everything happens in the serialEvent()
}

void serialEvent (Serial myPort) {
  // get the ASCII string:
  String inString = myPort.readStringUntil('\n');

  if (inString != null) {
    // trim off any whitespace:
    inString = trim(inString);
    // convert to an int and map to the screen height:
    float inFloat = float(inString); 
    float screenY = map(inFloat, minVal, maxVal, 0, height);

    // draw the line from bottom of screen to desired height
    stroke(127, 34, 255);
    line(xPos, height, xPos, height - screenY);

    // at the edge of the screen, go back to the beginning:
    if (xPos >= width) {
      xPos = 0;
      background(0);
    } else {
      // increment the horizontal position:
      xPos++;
    }
  }
}
*/
