/**
 * Interactive Device Design, Fall 2014
 * Homework 5 - Wind and Window controller
 * Freescale Freedom KL25Z Board
 *
 * Ian Shain
 * Doug Cook
 * Kiyana Salkeld
 * Elizabeth Lin
 *
 */

#include "mbed.h"
#include "Servo.h"
#include "Window.h"
#include <string>

Serial pc(USBTX, USBRX);
Serial ble(PTC4,PTC3); // PTC4 (purple) -> TX, PTC3 (gray) -> RX
const float ANALOG_HALF = 0.499;
const float ANALOG_DELTA = 0.011;
const float ANALOG_RANGE = 0.5;

DigitalOut red = LED_RED;
DigitalOut green = LED_GREEN;
DigitalOut blue = LED_BLUE;

// converts a voltage reading to a percent
double getAnalogPercent(float in) {
    return ((double)in / ANALOG_RANGE) * 100.0;   
}

// filter out garbage from the serial line
const char* validCodes = "abcdefgh0123456789";
bool isValidCode(char c) {
    for (int i = 0; validCodes[i] != '\0'; i++) {
        if (c == validCodes[i]) {
            return true;   
        }  
    }
    // pc.printf("invalid code detected: %c \r\n",c);
    return false;
}

char ble_CODE;
string ble_NUM_str = "";
int ble_NUM;
bool serialMessageAvailable = false;
void bleCallback() {
    if (ble_CODE == 'z') {
        char in = ble.getc();
        if (isValidCode(in)) {
            ble_CODE = in;
        } else {
            return;
        }
    } else {
        char in = ble.getc();
        if (isValidCode(in)) {
            ble_CODE = in;
        } else {
            return;
        }
       ble_NUM_str += ble.getc();
    }
    serialMessageAvailable = true;
}

int main() {
    // servo control for Window automation
    Servo s(D7);
    Window window(& s, 4.0);
    window.closeWindow();
    
    // status indicators
    red = 1;
    green = 1;
    blue = 1;
    
    // motor for anemometer
    AnalogIn motor(A0);
    AnalogOut motorBase(PTE30);
    motorBase.write(0.1);//(0.5);
    string motorSpeed = "";
    
    // serial
    ble.baud(9600);
    ble.format(8,Serial::Odd,1);
    ble.attach(bleCallback);

    while(1) {        
        // check for messages
        if (serialMessageAvailable) {
            switch(ble_CODE) {
                case 'a':
                    pc.printf("update minimum wind threshold to: ... \r\n");
                    break;
                case 'b':
                    pc.printf("update maximum wind threshold to: ... \r\n");
                    break;
                case 'c':
                    pc.printf("open window. \r\n");
                    if (!window.isWindowOpen()) {
                        window.openWindow();
                    }
                    break;
                case 'd':
                    pc.printf("close window. \r\n");
                    if (window.isWindowOpen()) {
                        window.closeWindow();   
                    }
                    break;
                case 'e':
                    pc.printf("initializing BLE device. \r\n");
                    red = 0;
                    wait(0.75);
                    red = 1;
                    break;
                case 'f':
                    pc.printf("restarting ble advertising. \r\n");
                    break;
                case 'g':
                    pc.printf("current wind speed: ... \r\n");
                    break;
                case 'h':
                    pc.printf("BLE device disconnected. \r\n");
                    break;
                default:
                    // pc.printf("uknown code received from BLE device: %c\r\n",ble_CODE);
                    break;
            }
            ble_CODE = 'z'; // flag indicating no code set
            serialMessageAvailable = false;  
        }

        // center input at zero (no wind is blowing)
        float val = motor.read() - ANALOG_HALF;
        float absoluteVal = abs(val);
        if (val < 0.0 - ANALOG_DELTA) {
            pc.printf("motor is turning NORTH %02f percent \r\n",getAnalogPercent(absoluteVal));
        } else if (val > 0.0 + ANALOG_DELTA) {
            pc.printf("motor is turning SOUTH %02f percent \r\n",getAnalogPercent(absoluteVal));
        }
        // transmit data to BLE
        ble.printf("%.0f",getAnalogPercent(absoluteVal));        
                
        wait(.5);
    }
}
