/* Window.cpp */
#include "Window.h"
#include "Servo.h"
#include "mbed.h"

Window::Window() {}

Window::Window(Servo* s, float timer) {
    servo = s;
    
    windowOpen = true;
    
    // Had to guess and check this value after
    // the servo was modified to move 360 degrees.
    servoStop = 0.48;
    
    // How long it takes for the window to completely
    // raise or lower.
    windowMovementTimer = timer;
    
    // closeWindow();
}

bool Window::isWindowOpen() {
    return windowOpen;
}

bool Window::openWindow() {
    if (!isWindowOpen()) {
        servo->write(0.6);
        windowOpen = true;
        wait(windowMovementTimer);
        servo->write(servoStop);
        windowOpen = true;
        return true;
    }
    // window already open
    return false;
}

bool Window::closeWindow() {
    if (isWindowOpen()) {
        servo->write(0.35);
        wait(windowMovementTimer);
        servo->write(servoStop);
        windowOpen = false;
        return true;
    }
    // window already closed
    return false;
}