/**
 * Interactive Device Design, Fall 2014
 * Homework 5 - Wind and Window controller
 * Nordic nrf51822 Board
 *
 * Ian Shain
 * Doug Cook
 * Kiyana Salkeld
 * Elizabeth Lin
 *
 */

#include "mbed.h"
#include "BLEDevice.h"
#include "HealthThermometerService.h"
#include "UARTService.h"
#include <string>

BLEDevice  ble;
DigitalOut led1(LED1);
DigitalOut led2(LED2);

UARTService *uartServicePtr;

Serial kl25z(P0_9, P0_11); // P0_9 (gray) -> TX, P0_11 (purple) -> RX

void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{
    kl25z.putc('h');
    kl25z.putc('f');
    ble.startAdvertising();
}

void onDataWritten(const GattCharacteristicWriteCBParams *params)
{
    if ((uartServicePtr != NULL) && (params->charHandle == uartServicePtr->getTXCharacteristicHandle())) {
        uint16_t bytesRead = params->len;
        if (bytesRead <= 1) {
            kl25z.putc('c');
        } else {
            kl25z.putc('d');
        }
        ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, bytesRead);
    }
}

bool updateWindAdvertisement = false;

void periodicCallback(void)
{
    led1 = !led1;
    updateWindAdvertisement = true;
}

bool newMessage = false;
string measurement = "";
void callback() {
    newMessage = true;
    measurement += kl25z.getc();
}

int main(void)
{
    led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);
    
    kl25z.baud(9600);
    kl25z.format(8,Serial::Odd,1);
    kl25z.attach(callback);

    //pc.printf("Initialising the nRF51822\n\r");
    kl25z.putc('e');
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);
    
    HealthThermometerService thermometerService(ble, 0, HealthThermometerService::LOCATION_EAR);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"AlloyWindow", sizeof("AlloyWindow") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    UARTService uartService(ble);
    uartServicePtr = &uartService;

    while (true) {
        if (newMessage) {
            led2 = !led2;   // data receiver notification
            // broadcast wind speed value
            thermometerService.updateTemperature(atoi(measurement.c_str()));
            measurement = "";
            newMessage = false;
        } else {
            ble.waitForEvent();
        }
    }
}
