#include "mbed.h"
//#include "USBMouse.h"
#include "USBMouseKeyboard.h"
#include "USBKeyboard.h"
#include "MMA8451Q.h"
#include "TSISensor.h"
#include "math.h"
#include "DebounceIn.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1)

//USBMouse mouse(ABS_MOUSE);
USBMouseKeyboard mouse;
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
TSISensor tsi;
//Serial pc(USBTX, USBRX);

DebounceIn wkey(D4);
DebounceIn akey(D5);
DebounceIn skey(D6);
DebounceIn dkey(D7);

main (void)
{
    int16_t x_mouse = 0;
    int16_t y_mouse = 0;
    int t = 0;
    float x = 0; float x_cal = 0;
    float y = 0; float y_cal = 0;
    int calib_cnt = 0;
    int walks = 0, walka = 0, walkd = 0, walkw = 0;
    
    while (calib_cnt < 100) {
        x_cal += acc.getAccX();
        y_cal += acc.getAccY();
        calib_cnt++;
        wait(0.01);
    }
    x_cal = x_cal/calib_cnt;
    y_cal = y_cal/calib_cnt;
    
    while(1) {
        x = acc.getAccX();
        y = acc.getAccY();
        x_mouse = floor(-(x-x_cal)*10);
        y_mouse = floor(-(y-y_cal)*6);
        mouse.move(x_mouse,y_mouse);
        t = tsi.readDistance();
        
        if (skey == 0) {
            mouse.printf("s");
            walks = 1;
        }
        if (dkey == 0) {
            mouse.printf("d");
            walkd = 1;
        }
        if (akey == 0){
            mouse.printf("a");
            walka = 1;
        }
        if (wkey == 0) {
            mouse.printf("w");
            walkw = 1;
        }
            
        if (walks == 1 && skey == 1) {
            mouse.releaseKey('s',0);
            walks = 0;
        }
        if (walka == 1 && akey == 1) {
            mouse.releaseKey('a',0);
            walka = 0;
        }
        if (walkd == 1 && dkey == 1) {
            mouse.releaseKey('d',0);
            walkd = 0;
        }
        if (walkw == 1 && wkey == 1) {
            mouse.releaseKey('w',0);
            walkw = 0;
        }
        
                
        if (t != 0) {
            mouse.press(1);
            mouse.release(0);
        }
        else {
            mouse.release(1);
            mouse.press(0);
        }
        wait(0.001);
    }
}