/**
 * Class KeyManager
 *
 * This class tracks the state of the four input
 * buttons and returns state information and
 * mappings.
 *
 */

#ifndef KEYMANAGER
#define KEYMANAGER

#include <string>
#include <ctype.h>

class KeyManager {
private:
    // key definitions
    bool keyA;
    bool keyB;
    bool keyC;
    bool keyZ;
        
public:
    
    // constructor
    KeyManager() {
        keyA = false;
        keyB = false;
        keyC = false;
        keyZ = false;
    }
    
    // DEBUG: return the status of which keys are pressed
    char* getStatusString() {
        std::string status = "the following keys are pressed:";
        if (keyA) {
           status += " A";
        }
        if (keyB) {
           status += " B";
        }
        if (keyC) {
           status += " C";
        }
        if (keyZ) {
           status += " Z";
        }
        status += "\n";
        return (char*)status.c_str(); 
    }
    
    // map the current code to its character
    char getCharacter() {
        if (keyA) {
            return 'a';
        }
        if (keyB) {
            return 'b';
        }
        if (keyC) {
            return 'c';
        }
        if (keyZ) {
            return 'z';
        }
        return '?';
    }
    
    // check whether any of the character keys or the space
    // key are pressed
    bool keysPressed() {
        if (keyA || keyB || keyC || keyZ) {
            return true;   
        }
        return false;
    }
    
    // Interrupt callback functions
    void keyAOn() { keyA = true; }
    void keyAOff() { keyA = false; }
    void keyBOn() { keyB = true; }
    void keyBOff() { keyB = false; }
    void keyCOn() { keyC = true; }
    void keyCOff() { keyC = false; }
    void keyZOn() { keyZ = true; }
    void keyZOff() { keyZ = false; }

};

#endif