#include "mbed.h"
#include "DebounceIn.h"
#include "USBKeyboard.h"

USBKeyboard keyboard;
Serial pc(USBTX, USBRX);
DebounceIn buttons[] = {D15, D14, D13, D12, D11, D10, D9, D8, D7, D6};
DigitalOut capslock_light(LED1);
int num_buttons = 10;
int is_capital = 0;
float key_delay = 0.2;

int main() {
    for (int i = 0; i < num_buttons; i++) {
        buttons[i].mode(PullUp);
        pc.printf("button %d is in pullup\n", i);
    }
    capslock_light = 1;
    is_capital = 0;
    pc.printf("starting loop");
    while(1) {
        for (int i = 2; i < num_buttons; i++) {
            if (!buttons[0] && !buttons[1]) {
                if (!buttons[4]) {
                    // space
                    keyboard.keyCode(' ');
                    wait(key_delay);
                    continue;
                }
                else if (!buttons[5]) {
                    // backspace
                    char backspace = 8;
                    keyboard.keyCode(backspace);
                    wait(key_delay);
                    continue;
                }
                else if (!buttons[6]) {
                    // capslock
                    capslock_light = !capslock_light;
                    keyboard.keyCode(KEY_CAPS_LOCK);
                    wait(key_delay);
                    continue;
                }
            }
    
            char base_char = 'a';
            if (!buttons[0] && !buttons[1]) {
                base_char = 'y';
            }
            else if (!buttons[0]) {
                base_char = 'i';
            }
            else if (!buttons[1]) {
                base_char = 'q';
            }

            if (!buttons[i]) {
                keyboard.keyCode(base_char + i - 2);
                wait(key_delay);
            }
        }
    }
}
