#include "mbed.h"
#include "PinDetect.h"

Serial pc(USBTX, USBRX); // tx, rx

PinDetect button1(D7);
PinDetect button2(D6);
PinDetect button3(D5);
PinDetect button4(D4);
PinDetect button5(D3);

PinDetect buttonBottom(PTC0);
PinDetect buttonLeft(PTC7);
PinDetect buttonMid(PTC5);

int buttonSide = 0; //initialize to left
int buttonLevel = 0; //initialize to top

char key1[2][3] = {{'Q','A','Z'}, {'Y','H','N'}};
char key2[2][3] = {{'W','S','X'}, {'U','J','M'}};
char key3[2][3] = {{'E','D','C'}, {'I','K',' '}};
char key4[2][3] = {{'R','F','V'}, {'O','L','.'}};
char key5[2][3] = {{'T','G','B'}, {'P','!','?'}};
 
void key1Pressed(void) {
    pc.printf("%c",key1[buttonSide][buttonLevel]);
}
void key2Pressed(void) {
    pc.printf("%c",key2[buttonSide][buttonLevel]);
}
void key3Pressed(void) {
    pc.printf("%c",key3[buttonSide][buttonLevel]);
}
void key4Pressed(void) {
    pc.printf("%c",key4[buttonSide][buttonLevel]);
}
void key5Pressed(void) {
    pc.printf("%c",key5[buttonSide][buttonLevel]);
}

void keyLeftHeld(void) {
    //pc.printf("in left mode\r\n");
    buttonSide = 0;
    pc.printf("%c",'0');
}
void keyLeftReleased(void) {
    //pc.printf("in right mode\r\n");
    buttonSide = 1;
    pc.printf("%c",'1');
}

void keyLevelOff(void) {
    buttonLevel = 0;
    pc.printf("%c",'2');
}
void keyMidOn(void) {
    buttonLevel = 1;
    pc.printf("%c",'4');
}
void keyBottonOn(void) {
    buttonLevel = 2;
    pc.printf("%c",'6');
}

int main() {
    button1.mode(PullUp);
    button2.mode(PullUp);
    button3.mode(PullUp);
    button4.mode(PullUp);
    button5.mode(PullUp);
    buttonBottom.mode(PullUp);
    buttonLeft.mode(PullUp);
    buttonMid.mode(PullUp);

    
    button1.attach_asserted(&key1Pressed);
    button2.attach_asserted(&key2Pressed);
    button3.attach_asserted(&key3Pressed);
    button4.attach_asserted(&key4Pressed);
    button5.attach_asserted(&key5Pressed);

    //note that these are backwards from what you think they should be
    buttonLeft.attach_asserted_held(&keyLeftHeld);
    buttonLeft.attach_deasserted_held(&keyLeftReleased);
    //releasing either level button does the same thing
    buttonMid.attach_asserted_held(&keyLevelOff);
    buttonMid.attach_deasserted_held(&keyMidOn);
    buttonBottom.attach_asserted_held(&keyLevelOff);
    buttonBottom.attach_deasserted_held(&keyBottonOn);

    button1.setSampleFrequency();
    button2.setSampleFrequency();
    button3.setSampleFrequency();
    button4.setSampleFrequency();
    button5.setSampleFrequency();
    buttonLeft.setSampleFrequency();
    buttonLeft.setSamplesTillHeld(2);
    buttonMid.setSampleFrequency();
    buttonMid.setSamplesTillHeld(2);
    buttonBottom.setSampleFrequency();
    buttonBottom.setSamplesTillHeld(2);
    
    //indicate we're ready
    pc.printf("%c",'5');
    
    while(1) {
        //do nothing forever
    }
}
