/***
 * Interactive Device Design, Fall 2014
 * Homework 2 - Text Entry Device
 * Doug Cook
 *
 * This program will setup a 7-button text-entry device
 * with 5 keys corresponding to the binary numbers 1 - 32
 * which then map to the alphabet, starting at 1. The
 * remaining two keys act as space and shift keys. Extra
 * numbers beyond the 26 alpha character map to the
 * question mark. This program allows the Freedom KL25Z
 * act as a USB Keyboard (using the non-debug USB port).
 *
 */

#include "mbed.h"
#include "PinDetect.h"
#include "KeyManager.h"
#include "USBKeyboard.h"

// Constants
int PINDETECT_SAMPLE_FREQUENCY = 10000;

int main() {
    // LED configuration
    DigitalOut red(LED1);
    DigitalOut green(LED2);
    DigitalOut blue(LED3);
    red = 1;
    green = 1;
    blue = 1;

    // Push button declarations
    PinDetect button6(D11);
    PinDetect button5(D10);
    PinDetect button4(D9);
    PinDetect button3(D8);
    PinDetect button2(D7);
    PinDetect button1(D6);
    PinDetect button0(D5);
    
    // PC connection
    //Serial pc(USBTX, USBRX);
    USBKeyboard keyboard;
    
    // initialize key manager
    KeyManager keys = KeyManager();
    
    // Initialize push buttons and callbacks
    button0.mode(PullUp);
    button1.mode(PullUp);
    button2.mode(PullUp);
    button3.mode(PullUp);
    button4.mode(PullUp);
    button5.mode(PullUp);
    button6.mode(PullUp);
    button0.attach_asserted( &keys, &KeyManager::key0Off );
    button0.attach_deasserted( &keys, &KeyManager::key0On );
    button0.setSampleFrequency( PINDETECT_SAMPLE_FREQUENCY );
    button1.attach_asserted( &keys, &KeyManager::key1Off );
    button1.attach_deasserted( &keys, &KeyManager::key1On );
    button1.setSampleFrequency( PINDETECT_SAMPLE_FREQUENCY );
    button2.attach_asserted( &keys, &KeyManager::key2Off );
    button2.attach_deasserted( &keys, &KeyManager::key2On );
    button2.setSampleFrequency( PINDETECT_SAMPLE_FREQUENCY );
    button3.attach_asserted( &keys, &KeyManager::key3Off );
    button3.attach_deasserted( &keys, &KeyManager::key3On );
    button3.setSampleFrequency( PINDETECT_SAMPLE_FREQUENCY );
    button4.attach_asserted( &keys, &KeyManager::key4Off );
    button4.attach_deasserted( &keys, &KeyManager::key4On );
    button4.setSampleFrequency( PINDETECT_SAMPLE_FREQUENCY );
    button5.attach_asserted( &keys, &KeyManager::keySpaceOff );
    button5.attach_deasserted( &keys, &KeyManager::keySpaceOn );
    button5.setSampleFrequency( PINDETECT_SAMPLE_FREQUENCY );
    button6.attach_asserted( &keys, &KeyManager::keyMOff );
    button6.attach_deasserted( &keys, &KeyManager::keyMOn );
    button6.setSampleFrequency( PINDETECT_SAMPLE_FREQUENCY );

    // listen for keystrokes
    while(1) {
        if (keys.keysPressed()) {
            // wait to read the character in case the user 
            // intended to press multiple keys and didn't hit
            // them all at once.
            wait(0.1);
            // pc.printf("%c",keys.getCharacter());   // DEBUG
            keyboard.printf("%c", keys.getCharacter());
            
            // wait a longer period to ensure multiple key
            // presses don't trigger unintentional characters.
            wait (0.25);
        } else {
            // cycle again
            wait(0.05);
        }
    }
};
