#include "mbed.h"
#include "DebounceIn.h"
#include "USBKeyboard.h"

// Serial connection for debugging
Serial pc(USBTX, USBRX);
// mimic USB keyboard
USBKeyboard keyboard;
// LED
DigitalOut red(LED_RED);
DigitalOut green(LED_GREEN);
DigitalOut blue(LED_BLUE);
// Push Buttons with Debounce 
DebounceIn pb1(D2);
DebounceIn pb2(D3);
DebounceIn pb3(D4);
DebounceIn pb4(D5);
DebounceIn pb5(D6);

// chord character map      
char chord_characters[32] = { 
    '?', // 00000 0
    'e', // 00001 1
    'd', // 00010 2
    'i', // 00011 3
    'c', // 00100 4
    'l', // 00101 5
    'h', // 00110 6
    'v', // 00111 7
    'b', // 01000 8
    'n', // 01001 9
    'k', // 01010 10
    'u', // 01011 11
    'g', // 01100 12
    't', // 01101 13
    's', // 01110 14
    ' ', // 01111 15 SPACE
    'a', // 10000 16
    'o', // 10001 17
    'm', // 10010 18
    'y', // 10011 19
    'j', // 10100 20
    'x', // 10101 21
    'r', // 10110 22
    '?', // 10111 23
    'f', // 11000 24
    'w', // 11001 25
    'q', // 11010 26
    'z', // 11011 27
    'p', // 11100 28
    '?', // 11101 29
    '\b', // 11110 30
    '\n', // 11111 31
};
  
// print binary representation of char for debugging                     
void printbinchar(char c)
{
    for (int i = 7; i >= 0; --i)
    {
        pc.printf("%c", ( (c & (1 << i)) ? '1' : '0' ));
    }
    pc.printf("\r\n");
}

void setup() {
    // use internal pullup for pushbuttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    pb5.mode(PullUp);
    // delay for initial pullup to take effect
    wait(0.1);
    // setup LED's
    red = 1, green = 1, blue = 1;
}

int main() {
    setup();
    int keycode = 0;
    while(1) {        
        // determine which push buttons are depressed
        if(!pb1){ keycode |= 1; }
        if(!pb2){ keycode |= 2; }
        if(!pb3){ keycode |= 4; }
        if(!pb4){ keycode |= 8; }
        if(!pb5){ keycode |= 16; }
        // when all buttons are released and some buttons were previously depressed
        if(pb1 && pb2 && pb3 && pb4 && pb5 && keycode)
        {
            int chr = chord_characters[keycode];
            pc.printf("%c", chr);
            keyboard.printf("%c", chr);
            
            //pc.printf("%d, %c\r\n", chr, chr);
            //printbinchar(chr);
            //printbinchar(keycode);
            keycode = 0;
        }
    }
}

//=============================
// python code to generate chord_characters array
// import binascii
//
// chord_map = {
//       "10000":"a",
//       "01000":"b",
//       "00100":"c",
//       "00010":"d",
//       "00001":"e",
//       "11000":"f",
//       "01100":"g",
//       "00110":"h",
//       "00011":"i",
//       "10100":"j",
//       "01010":"k",
//       "00101":"l",
//       "10010":"m",
//       "01001":"n",
//       "10001":"o",
//       "11100":"p",
//       "11010":"q",
//       "10110":"r",
//       "01110":"s",
//       "01101":"t",
//       "01011":"u",
//       "00111":"v",
//       "11001":"w",
//       "10101":"x",
//       "10011":"y",
//       "11011":"z",
//       "11110":"?",  
//       "10111":"?",
//       "11101":"?",
//       "01111":" ",
//       "11111":"?",
//       }
//
// if __name__ == '__main__':
//     array = [0] * 32
//         for k, v in chord_map.iteritems():
//             array[ int(k, 2) ] = k
//         for i in range(len(array)):
//             try:
//                 print "'" + chord_map[array[i]] + "', //", array[i], i
//             except KeyError:
//                 print "'" + "?" + "', //", array[i], i
//===================================================