#include "mbed.h"
Serial pc(USBTX, USBRX); // tx, rx
 
DigitalIn switch1(D13); // input switch
DigitalOut led(D12); // light on.

AnalogIn p1(A0);
AnalogIn p2(A1);
AnalogIn p3(A2);
AnalogIn p4(A3);
AnalogIn p5(A4);

int sw1 = 0; // input variable

int p1s=0; // individual input with switches
int p2s=0;
int p3s=0;
int p4s=0;
int p5s=0;

float ps[] = {0, 0, 0, 0, 0};
int psl[] = {0,0,0,0,0};

int binary = 0; // binary input
int ascii_c = 0; // capital
int ascii_l = 0; // lower letter
bool CAPS =0;// Caps Lock history variable.

bool lastButton = 0;
bool currentButton = 0; 
bool current =0;

bool debounce(bool last) // function for debounce
{
    sw1 = switch1.read(); // reads current switch status
    current = sw1;
    if (last != current)
    {
        wait(0.01); //eliminating bouncing with delayx
        current = sw1;    
    }
    return current;        
}

int encode(int reading)
{
    ps[0] = p1.read();
    ps[1] = p2.read();
    ps[2] = p3.read();
    ps[3] = p4.read();
    ps[4] = p5.read();
    for(int i =0;i<5;i++)
    {
    if(ps[i]>0.005)
    {
        psl[i] =1;
    }
    else 
    {
        psl[i] =0;
    }
    }
    binary = psl[4]*16 + psl[3]*8 + psl[2]*4+psl[1]*2+psl[0]*1;
    return binary;
    }

int main(){
 
    while(1)
    {
    led =1;  // led on!
        
    currentButton = debounce(lastButton);
    if (lastButton ==0 && currentButton ==1)
    {
    encode(binary);
    if(binary<=25)// 0-25 : A-Z.
    {
    switch(CAPS)
    {
    case 0 : // Capital
    ascii_c = binary + 65; 
    pc.printf("%c",ascii_c);
    break ;
    
    case 1 : //lower case    
    ascii_c = binary +97;
    pc.printf("%c",ascii_c);
    break;
    
    }
    }
    //else if for CAPS
    else
    {
        switch(binary)
        {
            case 26 :
            ascii_c = binary + 20; // prints out '.' 
            pc.printf("%c",ascii_c);   
            break;
            
            case 27 :
            ascii_c = binary + 36; // prints out '?' 
            pc.printf("%c",ascii_c);   
            break;
            
            case 28 :
            ascii_c = binary + 4; // prints out 'space' 
            pc.printf("%c",ascii_c);   
            break;
            
            case 29 :
            ascii_c = binary -21; // backspace
            pc.printf("%c",ascii_c);   
            break;
            
            case 30 :
            ascii_c = binary - 17; // prints out 'enter' 
            pc.printf("\n%c",ascii_c);   
            break;
            
            case 31 : //CAPS Lock 
            CAPS =! CAPS;
            break;
    
            }
    }
    
    }    
    lastButton = currentButton;

    }
}
