#include "mbed.h"
#include "LSM303DLHC.h"
#include "USBMouseKeyboard.h"
 
 
USBMouseKeyboard mouseKeyboard(ABS_MOUSE);
LSM303DLHC compass(PTC11, PTC10);
InterruptIn switchButton(D13);
AnalogIn fireButton(A0);


const float FLEX_THRESHOLD = .6;
float lastFlexValue = 0;
bool spaceHit = false;


void hitSpace(void) {
    /* Register trigger that the SPACE control button has been hit */
    spaceHit = true;   
}


bool wasFlexReleased(void) {
    /* Check to see whether the flex sensor was released according to predetermined threshold. */
    bool released = false;
    float flexValue = fireButton.read();
    if ((lastFlexValue > FLEX_THRESHOLD) && (flexValue < FLEX_THRESHOLD)) {
        released = true;
    }
    lastFlexValue = flexValue;
    return released;
}


int main(void) {
    
    /* Variables for sensing orientation */
    int16_t x_center = (X_MAX_ABS - X_MIN_ABS)/2;
    int16_t y_center = (Y_MAX_ABS - Y_MIN_ABS)/2;
    float xRot, yRot, nullRot;
    int16_t xPos, yPos;

    /* When the switch button is hit, register SPACE getting hit */
    switchButton.fall(&hitSpace);
    
    while (1) {
        /* This loop just checks sensors and maps them to keyboard and mouse motions that
            will accurately enough control the game that has been opened in a browser
            and centered in the middle of the screen. */
        
        /* Detect rotation from the compass. We don't care about several compass variables,
            (the ones returned into the nullRot variable) so we just pass in an unused variable. */
        /* The x and y that we compute don't appear to be perfectly accurate mappings to the
            rotating compass -- the radius of the circle changes as one rotates. But the
            heuristic effect we get below is good enough for playing Zuma. */
        compass.read(&nullRot, &nullRot, &nullRot, &xRot, &yRot, &nullRot);
        xPos = x_center + int16_t(xRot * 12000);
        yPos = y_center + int16_t(yRot * 12000);
        
        /* Move the mouse to a rotated position on a circle centered at the middle of the screen */
        mouseKeyboard.move(xPos, yPos);
        
        /* Check on flex sensor to see if ball was fired */
        bool fired = wasFlexReleased();
        if (fired) {
            mouseKeyboard.click(xPos, yPos, MOUSE_LEFT);   
        }
        
        /* Check to see if button for hitting SPACE was triggered */
        if (spaceHit == true) {
            mouseKeyboard.printf(" "); 
            spaceHit = false;           
        }
        
        /* Put a healthy amount of space between each iteration */
        wait_ms(10);
    }
}