#include "mbed.h"
#include "USBKeyboard.h"

DigitalOut A_in(D0);
DigitalOut B_in(D1);
DigitalOut C_in(D2);

DigitalOut A_out(PTC7);
DigitalOut B_out(PTC0);
DigitalOut C_out(PTC3);

AnalogOut dac(PTE30);
AnalogIn  adc(PTB0);

USBKeyboard keyboard;

int main () {
    float test_val = .001;
    int con_mat[8][8] = {};
    int a1,b1,c1,a2,b2,c2;
    //dac = test_val;

    for (int x = 0; x < 8; x++) {
        for (int y = 0; y < 8; y++) {
            // Stupid logic to convert count value to binary...
            A_in = x%2; a1 = x%2;
            B_in = (x/2)%2; b1 = (x/2)%2;
            C_in = (x/4)%2; c1 = (x/4)%2;
                
            A_out = y%2; int a2 = y%2;
            B_out = (y/2)%2; b2 = (y/2)%2;
            C_out = (y/4)%2; c2 = (y/4)%2;
            
            // Now we do the scan test, results are stored in con_mat
            //wait(0.01);
            dac = test_val;
            float in_val = adc.read();
            
            if ((in_val > .0015) && (in_val < .0025))
                con_mat[x][y] = 1;
            else
                con_mat[x][y] = 0;
            
            keyboard.printf("%f %f \n",dac.read(),in_val);
            //keyboard.printf("%d %d %d\n",a2,b2,c2);
        }
    }
    
    for (int x=0;x<8;x++) {
        for (int y=0;y<8;y++) {
            keyboard.printf("%d ",con_mat[x][y]);
        }
    }
    
}