#include "mbed.h"
#include "USBKeyboard.h"

SPI spi(PTD2, PTD3, PTD1); // mosi, miso, sclk
DigitalOut csADC(PTD0); // chip select for the ADC
DigitalOut csDAC(PTD5); // chip select for the DAC
AnalogOut test_out(PTE30); // analog out
AnalogIn test_in(PTB0); // analog in
USBKeyboard keyboard;

PwmOut rled(LED_RED);
//PwmOut gled(LED_GREEN);
//PwmOut bled(LED_BLUE);

int main() {

    rled = 1.0;
    //spi.format(8,0);
    //spi.frequency(1000000);

    csADC = 1;
    csDAC = 1;
    test_sig = 0.1;
    wait(0.1);
    csDAC = 0;
    int intermediary = spi.write(0xFF);
    wait(0.01);
    csDAC = 1;
    csADC = 0;
    int out = spi.write(0x00);
    csADC = 1;
    test_out.write(0.01);
    
    while(1) {
        //test_out.write(0.01);
        //keyboard.printf("%f ",test_in.read());
        //keyboard.printf("%f \n",test_out.read());
        float th_low = test_out.read()*0.8;
        float th_high = test_out.read()*1.2;
        if ((test_in.read() > th_low) && (test_in.read() < th_high))
                rled = 0.0;
        else
            rled = 1.0;
        //keyboard.printf("%f ", th_low); keyboard.printf("%f ", test_in.read()); keyboard.printf("%f \n", th_high);
        wait(0.5);
    }    
}