#include "mbed.h"
#include <complex>
#include <cmath>
#include <iostream>
#include <math.h>
#include <stdio.h>
69669.



Serial pc(USBTX, USBRX);
AnalogIn ain(p20); 
DigitalOut myled(LED2);
float f;

int main() {
    bool series_or_not = true;
    double freq = 35000;
    double C1 = 0.00000000001;
    double R1 = 3;
    double R2 = 10000;
    double R3 = 10000;
    double Rx, Cx;
    std::complex<double> X,  C, Zr1(R1, 0), Zr2(R2, 0), Zr3(R3, 0), Zc1(0, -pow((freq * 2 * 3.1415*C1), -1));
    C = Zr2 / (Zr1 + Zr2 + Zc1);
    double Rset = -24000;
    double Cset = 0.000000000068;
    std::complex<double> ZR(Rset,0), ZC(0,-pow((freq * 2 * 3.1415*Cset), -1));

    std::complex<double> output;
    if (series_or_not) {

        output = (Zr3)/(ZR + ZC+ Zr3) - C;

    }
    else {
        output = Zr3/(pow(pow(ZC, -1)+pow(ZR, -1),-1)+Zr3) - C;
    }
    double Ratio = abs(output);
    double phi = arg(output);
    
    pc.printf("%f\n\r",Ratio);
    pc.printf("%f\n\r",phi); 
}
