#include "mbed.h"
#include <complex>
#include <cmath>
#include <iostream>
#include <math.h>
#include <stdio.h>


AnalogIn Vphi(p16);//from 0v-3v to 0-360degree
AnalogIn Vinpk(p19);
AnalogIn Voutpk(p20);// 
AnalogIn Vgnd(p15);

DigitalOut f_selector(p8);
DigitalOut C_selector1(p29);
DigitalOut C_selector2(p30);
DigitalOut R_selector1(p27);
DigitalOut R_selector2(p28);

Serial pc(USBTX, USBRX); // tx, rx

const int f[2] = {35000,7246};
const double C1[4] = {0.000000000019,0.0000000000247,0.000000000571,0.0000022};//
const double R2[4] = {82000,10000,1000,100};// 
const double R1 = 3;
double R3;

struct RCset {
    double R;
    double C;
};

RCset getCR(double phi,double Ratio,int freq,bool series_or_not, double C_best,double R_best);

int main() {
    f_selector = 0;
    C_selector1 = 1;
    C_selector2 = 0;
    R_selector1= 1;
    R_selector2 = 1;
    
    while (1){
    double R_best = R2[R_selector2+2*R_selector1];    
    double C_best = C1[C_selector2+2*C_selector1];
    double f_best = f[f_selector];
    double phase_best = (Vphi*3.3)/3*2*3.1415;
    double ratio_best = (Voutpk-Vgnd)/(Vinpk-Vgnd);
    
    RCset series0,series1,parallel0,parallel1,result,parallel;
    

    
    
    parallel = getCR(phase_best,ratio_best,f_best,1,C_best,R_best);

    
    printf("%.6f \n\r",phase_best); 
    printf("%.6f \n\r",ratio_best); 
    printf("the unknowm resistor is %f\n\r",parallel.R);
    printf("the unknowm capacitor is %.6f nF\n\r",parallel.C);
    
    wait(0.5);
    }
}


RCset getCR(double phi,double Ratio,int freq,bool series_or_not, double C_best,double R_best){
    double Rx, Cx;
    R3 = R_best;
    RCset output;
    std::complex<double> X,  C, Zr2(R_best, 0), Zr1(R1, 0), Zr3(R3, 0), Zc1(0, -pow((freq * 2 * 3.1415*C_best), -1));
    std::complex<double> Vdiff(Ratio*cos(phi), Ratio*sin(phi));

    C = Zr2 / (Zr1 + Zr2 + Zc1);
    X = Zr3*(pow(Vdiff + C, -1)) - Zr3;

    if (series_or_not) {

        Rx = real(X);
        Cx = -1 / (freq * 2 * 3.1415*imag(X));

    }
    else {

        Rx = (real(X)) * (1 + pow(imag(X) / real(X),2));
        Cx = -(imag(X))/(real(X)*Rx*2*3.1415*freq);

    }
    output.R = Rx;
    output.C = Cx*1000000000;
    pc.printf("%f\n\r",real(X));
    pc.printf("%f\n\r",Rx);
    pc.printf("%f\n\r", output.R);
    pc.printf("%f\n\r",imag(X));   
    return output; 

}    
