#include "mbed.h"
#include <complex>
#include <cmath>
#include <iostream>
#include <math.h>
#include <stdio.h>


AnalogIn Vphi(p16);//from 0v-3v to 0-360degree
AnalogIn Vinpk(p19);
AnalogIn Voutpk(p20);// 
AnalogIn Vgnd(p15);

DigitalOut f_selector(p8);
DigitalOut C_selector1(p29);
DigitalOut C_selector2(p30);
DigitalOut R_selector1(p27);
DigitalOut R_selector2(p28);

Serial pc(USBTX, USBRX); // tx, rx

const int f[2] = {35587,7353};
const double C1[4] = {0.00000000012,0.00000000134,0.00000022002,0.0000022};//
//const double C1[4] = {0.000000000171,0.000000001221,0.00000022002,0.0000022};//
std::complex<double> a(71600,-27100);
std::complex<double> b(9960,-457);
std::complex<double> c(1000,0);
std::complex<double> d(100,0);
std::complex<double> e(81491,-6388);
std::complex<double> g(9998,-95);
std::complex<double> R2[6];// 
const double R1 = 3;
const int f_set[5] = {1,1,1,0,0};
const int R_set[5] = {3,2,1,1,0};
const int C_set[5] = {3,2,2,1,0};
const double threshold[4] = {75,7.5,0.75,0.0};
//const double Range_set[5] = {0.00000000001,0.0000000001,0.000000001,0.00000001,0.0000001}; 
std::complex<double> R3;


struct RCset {
    double R;
    double C;
};

struct sampleavg {
    double phi;
    double out;
    double in;
    double gnd;
};

RCset getCR(double phi,double Ratio,int freq,bool series_or_not, double C_best,std::complex<double> R_best);

sampleavg sample(double samples);

int main() {
    RCset series0,series1,parallel0,parallel1,result;
    double C_best,f_best,phase_best,ratio_best;
    bool rightrange; 
    int r;
    std::complex<double> R_best;
    
    R2[0] = a;
    R2[1] = b;
    R2[2] = c;
    R2[3] = d;
    R2[4] = e;
    R2[5] = g;
    
    sampleavg avg;
    
    while (1){
        r = 0;
        rightrange = false;
        while(!rightrange && r < 4) {
            C_selector2 = C_set[r]%2;
            C_selector1 = (C_set[r]/2)%2;
            R_selector2 = R_set[r]%2;
            R_selector1 = (R_set[r]/2)%2;
            f_selector = f_set[r];
            if(f_selector == 1 && R_set[r] < 2){
                R_best = R2[R_set[r]+4];
            }
            else{
                R_best = R2[R_set[r]];
            }  
            C_best = C1[C_set[r]];
            f_best = f[f_selector];
            
            wait(0.75);
            
            avg = sample(20);
            phase_best = (avg.phi*3.3)/3*2*3.1415;
            ratio_best = ((avg.gnd-avg.out))/((avg.gnd-avg.in));
            
            result = getCR(phase_best,ratio_best,f_best,0,C_best,R_best);
            
            if  (result.C < threshold[r] ||  ratio_best > 0.95){
                r++;
            }
            else {
                rightrange = true;
            }
            
            printf("%.6f \n\r",result.C); 
            //printf("%.6f \n\r",ratio_best); 
            printf("\n\r");
            
//            f_selector = 0;
//            f_best = f[f_selector];
//            
//            phase_best = (Vphi*3.3)/3*2*3.1415;
//            ratio_best = (Voutpk-Vgnd)/(Vinpk-Vgnd);
//            parallel0 = getCR(phase_best,ratio_best,f_best,1,C_best,R_best);
//            series0 = getCR(phase_best,ratio_best,f_best,1,C_best,R_best);
//            
//            f_selector = 1 ;
//            f_best = f[f_selector];
//            
//            phase_best = (Vphi*3.3)/3*2*3.1415;
//            ratio_best = (Voutpk-Vgnd)/(Vinpk-Vgnd);
//            parallel1 = getCR(phase_best,ratio_best,f_best,1,C_best,R_best);
//            series1 = getCR(phase_best,ratio_best,f_best,1,C_best,R_best);
//            
//            if (abs(parallel0.R - parallel1.R)> abs(series0.R - series1.R)){
//                result.C = (series0.C + series1.C)/2;
//                result.R = (series0.R + series1.R)/2;
//                if ((result.C > Range_set[r])&&(result.C < Range_set[r+1])){
//                    rightrange = true;
//                }
//                else {
//                    r--;
//                }
//            }
//            else {
//                result.C = (parallel0.C + parallel1.C)/2;
//                result.R = (parallel0.R + parallel1.R)/2;
//                if ((result.C > Range_set[r])&&(result.C < Range_set[r+1])){
//                    rightrange = true;
//                }
//                else {
//                    r--;
//                }
//            }
        }
        if(f_selector == 1 && R_set[r] < 2){
            R_best = R2[R_set[r]+4];
        }
        else{
            R_best = R2[R_set[r]];
        }  
        C_best = C1[C_set[r]];
        f_best = f[f_selector];
        
        avg = sample(100);
        phase_best = (avg.phi*3.3)/3*2*3.1415;
        ratio_best = ((avg.gnd-avg.out))/((avg.gnd-avg.in));
            
        result = getCR(phase_best,ratio_best,f_best,0,C_best,R_best);
        
        pc.printf("Range is: ");
        if (r == 0){
            pc.printf("100nF-1uF\n\r");
        }
        else if (r == 1){
            pc.printf("10nF-100nF\n\r");
        }
        else if (r == 2){
            pc.printf("1nF-10nF\n\r");
        }
        else if (r == 3){
            pc.printf("100pF-1nF\n\r");
        }
        else if (r == 4){
            pc.printf("10pF-100pF\n\r");
        }
        else {
            pc.printf("fatal error\n\r");
        }
        printf("the unknowm resistor is %f\n\r",result.R);
        printf("the unknowm capacitor is %.6f nF\n\r",result.C);
        printf("\n\r");
    }
}


RCset getCR(double phi,double Ratio,int freq,bool series_or_not, double C_best,std::complex<double> R_best){
    double Rx, Cx;
    R3 = R_best;
    RCset output;
    std::complex<double> X,  C, Zr2 = R_best, Zr1(R1, 0), Zr3 = R3, Zc1(0, -pow((freq * 2 * 3.1415*C_best), -1));
    std::complex<double> Vdiff(Ratio*cos(phi), Ratio*sin(phi));

    C = Zr2 / (Zr1 + Zr2 + Zc1);
    X = Zr3*(pow(Vdiff + C, -1)) - Zr3;

    if (series_or_not) {

        Rx = real(X);
        Cx = -1 / (freq * 2 * 3.1415*imag(X));

    }
    else {

        Rx = (real(X)) * (1 + pow(imag(X) / real(X),2));
        Cx = -(imag(X))/(real(X)*Rx*2*3.1415*freq);

    }
    output.R = Rx;
    output.C = Cx*1000000000; 
    return output; 

}     

sampleavg sample(double samples){
    sampleavg avg;
    for(double i = 0; i<samples; i++){
        avg.phi = avg.phi+Vphi;
        avg.out = avg.out+Voutpk;
        avg.in = avg.in+Vinpk;
        avg.gnd = avg.gnd+Vgnd;
    }
    avg.phi = avg.phi/samples;
    avg.out = avg.out/samples;
    avg.in = avg.in/samples;
    avg.gnd = avg.gnd/samples;
    return avg;
}