 /** 
  * File:    nxp_can/main.cpp
  * 
  * Author1:  Carla Amaya
  * Author2:  Gerardo Cordero
  * Author3:  José Pesado
  * Author3:  Jalil Chávez
  *
  * Date:     October 2014  
  * Course:   Instrumentation
  * 
  * Summary of File: 
  * 
  *   This file contains code which sends data through
  *   a CAN bus that is received from a Xbee. This data comes
  *   from a line follower.
  * Rev 0.1 18/10/2014
  * - Initial revision
  */ 
  
/**
* Header files
*/
#include "mbed.h"
#include "xbee.h"
 
/**
* Object initialization
*/
Ticker tickerMSG;
DigitalOut aliveIndicator(LED1);
CAN can1(p30, p29);
extern Serial PC;

/**
* Global variable declaration
*/

/*                       DL   B0   B1   B2   B3   B4   B5   B6   B7   */
static char CBC_PT1[] = {0x08,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00};
static char CBC_PT2[] = {0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
static char ECM_A1[] =  {0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
static char ESP_A8[] =  {0x08,0x22,0xF1,0x22,0x00,0x00,0x00,0x00,0x64};

uint16_t u16Speed = 0;
uint16_t u16RPM = 0;
char inBuffer[BUFFER_SIZE]={0};

static CANMessage canmsgCBC_PT1 = CANMessage(0x334,&CBC_PT1[1],CBC_PT1[0],CANData,CANStandard );
static CANMessage canmsgCBC_PT2 = CANMessage(0x112,&CBC_PT2[1],CBC_PT2[0],CANData,CANStandard );
static CANMessage canmsgECM_A1 = CANMessage(0x108,&ECM_A1[1],ECM_A1[0],CANData,CANStandard );
static CANMessage canmsgESP_A8 = CANMessage(0x11C,&ESP_A8[1],ESP_A8[0],CANData,CANStandard );

/**
* Local function
*/
void sendData() 
{
    static uint8_t ctr = 0;
    can1.frequency(500000);
        
    switch(ctr)
    {
        case 0:
            can1.write( canmsgCBC_PT1 );
            ctr++;
        break;
        case 1:
            u16RPM = 3*(inBuffer[4]<<8)|(inBuffer[3]);
            ECM_A1[1]=(char)((u16RPM>>8)&0xFF);
            ECM_A1[2]=(char)((u16RPM)&0x00FF);
            canmsgECM_A1 = CANMessage(0x108,&ECM_A1[1],ECM_A1[0],CANData,CANStandard );
            can1.write( canmsgECM_A1 );
            ctr++;
        break;
        case 2:
            ESP_A8[4]=inBuffer[2];
            ESP_A8[5]=inBuffer[1];
            canmsgESP_A8 = CANMessage(0x11C,&ESP_A8[1],ESP_A8[0],CANData,CANStandard );
            can1.write( canmsgESP_A8 );
            ctr++;
        break;
        case 3:
            can1.write( canmsgCBC_PT2 );
            ctr=0;
        break;
    }
}

/**
* Main program
*/
int main() {
    /* Start cyclic function */
    tickerMSG.attach(&sendData, 0.01);
    /* Main loop */
    XBee_vInit();
    while(1) 
    {
        aliveIndicator = !aliveIndicator;
        wait(0.2);
    }
}