#include "mbed.h"
#include "FXOS8700CQ.h"
 
FXOS8700CQ IMU( PTE25 /*SDA*/,
                PTE24 /*SCL*/,
                FXOS8700CQ_SLAVE_ADDR1/*ADDRESS*/
               );
 
//Temrinal enable
Serial pc(USBTX, USBRX);
 
SRAWDATA acc_data;
SRAWDATA mag_data;
 
 
int main()
{
    uint8_t u8Status = 0;
    pc.baud(115200);
    IMU.enable();
    pc.printf("\r\n\nFXOS8700Q Who Am I= %X\r\n", IMU.get_whoami());
 
    while (true)
    {
        u8Status = IMU.get_data(&acc_data,&mag_data);
        if( u8Status == 0 )
        {
            pc.printf("ACC: X=%i Y=%i Z=%i  \r", acc_data.x, acc_data.y, acc_data.z);
            pc.printf("MAG: X=%d Y=%d Z=%d  \r\n", mag_data.x, mag_data.y, mag_data.z);
        }
        else
        {
            pc.printf("COMMUNICATION UNSUCCESSFUL!!!!\r\n");
        }
        wait(0.1);
    }
}