#include "mbed.h"

DigitalOut led(LED_RED);
DigitalIn Reverse (PTC6);   //SW2 
//***********************************OUTL1, OUTL2******************************************************************
PwmOut PWML (D5);   //IN2  
DigitalOut ENDL (D4);   //EN_D2 is logic LOW, the H-Bridge A is placed in Sleep Mode
//DigitalIn  AD3  (D3);   //FeedBack provides current sensing feedback of the H-Bridge high side drivers. A ground-referenced 0.24% of load current is output to this pin.

//***********************************OUTR1, OUTR2******************************************************************
PwmOut PWMR (D7);  //IN2
DigitalOut ENDR (D6);   //EN_D2 is logic LOW, the H-Bridge B is placed in Sleep Mode.
//DigitalIn  AD4  (D4);   //FeedBack provides current sensing feedback of the H-Bridge high side drivers. A ground-referenced 0.24% of load current is output to this pin.

//DigitalIn SF    (A2);   //StatusFlag, Active LOW

int i;

int main()
{
    PWML.period(0.0909);    //11KHZ, 0.0909ms
    PWMR.period(0.0909);
    ENDL=1;
    ENDR=1;    //H-Bridges active
    
    while(1) {
        
        
        for (i=0;i<5000;i=i+1)     //5000 PWM cycles
        {
            PWML.write(i/5000); 
            PWMR.write(i/5000); 
            
            wait(0.01); 
        }
    }
}
    
    
