#include "mbed.h"

#define XBEE_SERVER         1
#define XBEE_CLIENT         1
#define SERIAL_BAUDRATE     115200
#define BUFFER_SIZE         9
#define BUFFER_FORMAT       "%X%X%X%X%X%X%X%X%X"
#define BUFFER_FORMAT_RX    "%c%c%c%c%c%c%c%c%c"
#define BUFFER_RX_DATA_WR   &CommandRx[0],&CommandRx[1],&CommandRx[2],&CommandRx[3],\
                            &CommandRx[4],&CommandRx[5],&CommandRx[6],&CommandRx[7],\
                            &CommandRx[8]
#define BUFFER_RX_DATA_RD   CommandRx[0],CommandRx[1],CommandRx[2],CommandRx[3],\
                            CommandRx[4],CommandRx[5],CommandRx[6],CommandRx[7],\
                            CommandRx[8]

Serial PC(USBTX, USBRX);
DigitalOut Indicator(LED_GREEN);
int XBee_u16Loop;

#if XBEE_SERVER == 1
Serial XBeeServer(PTC17, PTC16); /* Tx, Rx*/
char CommandTx[BUFFER_SIZE+1]={0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, '\0'};
DigitalOut RSTServer(PTB9);
int XBee_u16TxResult;
int XBee_u8TxRq;
#endif

#if XBEE_CLIENT == 1
Serial XBeeClient(PTE24, PTE25); /* Tx, Rx*/
DigitalOut RSTClient(PTA1);
char CommandRx[BUFFER_SIZE+1];
volatile int XBee_u8RxResult;
int XBee_boRxIndication = 0;
int XBee_boRxAllowed = 1;

/* This function is called when a character goes into the RX buffer.*/
void XBeeClientRx() {
    if(XBee_boRxAllowed == 1)
    {
        PC.printf("\r\nRx... ");
        XBee_u8RxResult = 0;
        XBee_u8RxResult = XBeeClient.scanf( BUFFER_FORMAT_RX, BUFFER_RX_DATA_WR );
        if(XBee_u8RxResult>0)
        {
            XBee_boRxIndication = 1;
        } 
        PC.printf("\r\nRx done [%i]. ",XBee_u8RxResult);
        PC.printf( BUFFER_FORMAT, BUFFER_RX_DATA_RD );
    }
    return;
}
#endif

void XBee_vInit(void)
{ 
    XBee_u16Loop = 0;
    
    PC.baud(SERIAL_BAUDRATE);
    
    #if XBEE_SERVER == 1
    PC.printf("\r\nSetting server XBee...");
    XBeeServer.baud(SERIAL_BAUDRATE); 
    XBee_u16TxResult = 0; 
    XBee_u8TxRq = 0;  
    #endif
    
    #if XBEE_CLIENT == 1
    PC.printf("\r\nSetting client XBee...");
    XBeeClient.baud(SERIAL_BAUDRATE);   
    XBeeClient.attach(&XBeeClientRx, Serial::RxIrq);
    XBee_u8RxResult = 0;
    XBee_boRxAllowed = 1;
    #endif    
    
    /* XBee reset*/
    #if XBEE_SERVER == 1
    RSTServer = 0;
    #endif
    #if XBEE_CLIENT == 1
    RSTClient = 0;
    #endif   
    wait_ms(1);
    #if XBEE_SERVER == 1
    RSTServer = 1;
    #endif
    #if XBEE_CLIENT == 1
    RSTClient = 1;
    #endif   
    wait_ms(1);
}

void XBee_vMain(void)
{
    XBee_u16Loop++;
    PC.printf("\r\n[%i]:",XBee_u16Loop);   
    
    if(XBee_u8TxRq == 1)
    {
        /* a Tx job request is active */
        PC.printf("\r\nTx... ");
        /* disable rx */
        XBee_boRxAllowed = 0;
        for (int i=0; i<BUFFER_SIZE; i++) 
        {
            while (true) 
            {
                if (XBeeServer.writeable()) 
                {
                    XBee_u16TxResult= XBeeServer.putc(CommandTx[i]);
                    PC.printf("%X ", XBee_u16TxResult);
                    break;
                }
            }
        }
        /* tx done */
        PC.printf("\r\nTx done. ");
        XBee_u8TxRq = 0;
        /* enable rx */
        XBee_boRxAllowed = 1;
    } 
}

#if 0

int main()
{
    char TxJob[BUFFER_SIZE+1] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, '\0'};    
    
    XBee_vInit();
    
    while (true) {
        wait(0.2f); // wait a small period of time
        Indicator = !Indicator; // toggle a led
        
        XBee_vMain();  
        
        memcpy(CommandTx,TxJob,9);
        XBee_u8TxRq = 1;
                
        for(int i=0;i<BUFFER_SIZE;i++)
        {
            TxJob[i]++;
        }
        
    }
}
#endif

