#ifndef _SRVCTL_H_
#define _SRVCTL_H_

#include "mbed.h"

/**********************************************************************************
* Servo parameters
***********************************************************************************/
#define START_POS 1700/* us
* Description: Minimum position of servo motor
*/

#define FINAL_POS 2400/* us
* Description: Maximum position of servo motor
*/

#define MIDDLE_POINT ( FINAL_POS - START_POS )/2/*
* Description: Middle point of servo motor
*/

#define SERVO_PERIOD 20/* ms
* Description: Period required to move servo motor
*/

/**********************************************************************************
* Variable types definition
***********************************************************************************/

/**********************************************************************************
* Global functions
***********************************************************************************/
void SRVCTL_vInit(void);
void SRVCTL_vSetPosition( uint16_t u16PosVal, const uint16_t u16MaxVal );

#endif
