#include "srvctl.h"

/**********************************************************************************
* Object declaration
***********************************************************************************/
PwmOut SRVCTL__xServo(PTD0);

void SRVCTL_vInit(void)
{
    /* Set the period required to move the servomotor */
    SRVCTL__xServo.period_ms(SERVO_PERIOD);
}

void SRVCTL_vSetPosition( uint16_t u16PosVal, const uint16_t u16MaxVal )
{
    uint16_t u16PulseWidth = MIDDLE_POINT;
    /* Adapt value to write into pwm channel */
    u16PulseWidth = START_POS + ( (FINAL_POS - START_POS) / u16MaxVal ) * (u16PosVal);
    /* Set duty cycle */
    SRVCTL__xServo. pulsewidth_us(u16PulseWidth);
}