#ifndef _MTRCTL_H_
#define _MTRCTL_H_

#include "mbed.h"

/**********************************************************************************
* Servo parameters
***********************************************************************************/
#define OP_PERIOD 90900/* us
* Description: operation period to control propulsion motors
*/

#define MAX_POWER 1000/*
* Description: logical, max value allowed for a PWM channel
*/

#define MIN_POWER 100/*
* Description: logical, min value allowed for a PWM channel
*/

#define MAX_DIRECTION_VAL 128/*
* Description: Maximum direction value, it means totally right, 0 means totally left
*/

#define SCALE_DIR2SPEED (uint16_t)(MAX_POWER/MAX_DIRECTION_VAL)

/**********************************************************************************
* Variable types definition
***********************************************************************************/
typedef enum
{
    nLeftMotor = 0,
    nRightMotor,
    nNoOfMotors
}MTRCTL_tenMotors;
/**********************************************************************************
* Global functions
***********************************************************************************/
void MTRCTL_vInit( void );
void MTRCTL_vSetMaxSpeed( uint16_t u16MaxSpeed );
void MTRCTL_vSetMotorPower( uint16_t u16InPwr, MTRCTL_tenMotors enMotor );
void MTRCTL_vSetSystemSpeed( uint16_t u16Speed, uint8_t u8Direction );

#endif