#ifndef _CAMCTL_H_
#define _CAMCTL_H_

#include "mbed.h"

/**********************************************************************************
* Camera parameters
***********************************************************************************/

#define BASE_PERIOD             20/* us
* Description: All times are based on this time
*/

#define START_DELAY             10/* x1000 = 1ms
* Description: All times are based on this time
*/

#define SI_PULSE_WIDTH          15/* x BASE_PERIOD = 10ms
* Description: Pulse width of SI signal
*/


#define SI_PULSE_WIDTH_HALF     (SI_PULSE_WIDTH/2)/* x BASE_PERIOD = 10ms
* Description: Pulse width of SI signal
*/

#define CLK_PULSE_WIDTH_HALF    (SI_PULSE_WIDTH/2)/* x BASE_PERIOD = 10ms
* Description: Pulse width of SI signal
*/

/*#define EXPOSURE_TIME       (uint8)(15)*//* x BASE_PERIOD = 10ms
* Description: Time between firts SI pulse and second one.
*/

#define CLK_PULSE_WIDTH         SI_PULSE_WIDTH/* x BASE_PERIOD = 10ms
* Description: Must be the same value used for SI_PULSE_WIDTH
*/

#define NO_OF_CLK_PULSES        129/*
* Description: Number of pulses to trigger between 2 SI pulses.
*/

#define IDLE_TIME               15/*us
* Description: Time to wait before the next SI pulse.
*/

#define BUFFER_LENGTH           128/*
* Description: Number of to get from linescan camera.
*/

/**********************************************************************************
* Variable types definition
***********************************************************************************/
typedef enum
{
    nContinuous = 0,
    nOneShot,
    nNone,
    nNumberOfModes
}CAMCTL__tenCaptureMode;

typedef struct
{
    uint8_t u8ActiveCapture : 1;
    uint8_t u8ClkEnd : 1;
    CAMCTL__tenCaptureMode enCaptureMode;
}CAMCTL__tstCameraOptions;

/**********************************************************************************
* Global functions
***********************************************************************************/
void CAMCTL_vInit(void);
void CAMCTL_vTriggerOneShotCapture(void);
void CAMCTL_vTriggerContinuousCapture(void);
void CAMCTL_vStopContinuousCapture(void);
uint16_t * CAMCTL_pu16GetData( void );
bool CAMCTL_boCalibrateCamera(uint16_t* pu16ThreshCalibration, uint8_t u8Frames2Wait);

#endif /* END OF _CAMCTL_H_ */