#include "camctl.h"

/**********************************************************************************
* Object declaration
***********************************************************************************/

DigitalOut CAMCTL__xPinSI(PTD1);
DigitalOut CAMCTL__xPinCLK(PTD3);
AnalogIn CAMCTL__xPinAN(PTB2);
DigitalOut debug(PTB3);
DigitalOut debugGetData(PTB10);

Timeout CAMCTL__xGlobalTimer;
Timeout CAMCTL__xClkTimer;
Timeout CAMCTL__xSiTimer;

/**********************************************************************************
* Local function prototypes
***********************************************************************************/
static void CAMCTL__vGlobalTimer(void);
static void CAMCTL__vSignalHdlr_SI(void);
static void CAMCTL__vSignalHdlr_CLK(void);

/**********************************************************************************
* Local variables
***********************************************************************************/
static CAMCTL__tstCameraOptions CAMCTL__stCameraOptions;
static uint16_t CAMCTL__au16LineBuffer[BUFFER_LENGTH] = {0};

/**********************************************************************************
* CAMCTL-Module
***********************************************************************************/
static void CAMCTL__vGlobalTimer()
{
    static bool boStartDone = false;
    if ( CAMCTL__stCameraOptions.enCaptureMode == nOneShot &&
         CAMCTL__stCameraOptions.u8ActiveCapture == true    &&
         CAMCTL__stCameraOptions.u8ClkEnd == false &&
         boStartDone == false )
    {
        CAMCTL__xSiTimer.attach_us(&CAMCTL__vSignalHdlr_SI, START_DELAY);
        CAMCTL__xClkTimer.attach_us(&CAMCTL__vSignalHdlr_CLK, START_DELAY + CLK_PULSE_WIDTH_HALF);
        boStartDone = true;
    }
    else if( CAMCTL__stCameraOptions.enCaptureMode == nOneShot &&
             CAMCTL__stCameraOptions.u8ActiveCapture == true    &&
             CAMCTL__stCameraOptions.u8ClkEnd == true &&
             boStartDone == true )
    {        
        boStartDone = false;
        CAMCTL__xGlobalTimer.detach();
        CAMCTL__xClkTimer.detach();
        CAMCTL__xSiTimer.detach();
    }
    else
    {
    }
    CAMCTL__xGlobalTimer.attach_us(&CAMCTL__vGlobalTimer,BASE_PERIOD);
}
void CAMCTL__vSignalHdlr_SI()
{
    static bool boSIDone = false;
    if( boSIDone == false )
    {
        boSIDone = true;
        CAMCTL__xPinSI = true;
        CAMCTL__xSiTimer.attach_us(&CAMCTL__vSignalHdlr_SI, SI_PULSE_WIDTH);
    }
    else
    {
        CAMCTL__xPinSI = false;
        boSIDone = false;
    }        
}
void CAMCTL__vSignalHdlr_CLK()
{
    static uint8_t u8PulseCtr = 0;
    
    if( u8PulseCtr < NO_OF_CLK_PULSES )
    {
        if ( u8PulseCtr == 0 )
        {
            CAMCTL__xPinCLK = true;
            u8PulseCtr++;
        }
        else
        {
            CAMCTL__xPinCLK = !CAMCTL__xPinCLK;
            if( CAMCTL__xPinCLK == false )
            {
                if( ( u8PulseCtr >= 1 ) && (u8PulseCtr < BUFFER_LENGTH )  )
                {
                    CAMCTL__au16LineBuffer[u8PulseCtr-1] = CAMCTL__xPinAN.read_u16();
                }
                u8PulseCtr++;
            }
        }
        CAMCTL__xClkTimer.attach_us(&CAMCTL__vSignalHdlr_CLK, CLK_PULSE_WIDTH);
    }
    else
    {
        u8PulseCtr = 0;
        CAMCTL__stCameraOptions.u8ClkEnd = true;
    }
        
}

void CAMCTL_vTriggerOneShotCapture()
{
    CAMCTL__stCameraOptions.u8ActiveCapture = true;
    CAMCTL__stCameraOptions.u8ClkEnd = false;
    CAMCTL__stCameraOptions.enCaptureMode = nOneShot;
    CAMCTL__xGlobalTimer.attach_us(&CAMCTL__vGlobalTimer,BASE_PERIOD);
}

void CAMCTL_vTriggerContinuousCapture()
{
    CAMCTL__stCameraOptions.u8ActiveCapture = true;
    CAMCTL__stCameraOptions.u8ClkEnd = false;
    CAMCTL__stCameraOptions.enCaptureMode = nContinuous;
    CAMCTL__xGlobalTimer.attach_us(&CAMCTL__vGlobalTimer,BASE_PERIOD);
}

void CAMCTL_vStopContinuousCapture( void )
{
    CAMCTL__stCameraOptions.u8ActiveCapture = false;
    CAMCTL__stCameraOptions.enCaptureMode = nNone;
    CAMCTL__xGlobalTimer.detach();
    CAMCTL__xClkTimer.detach();
    CAMCTL__xSiTimer.detach();
}

uint16_t * CAMCTL_pu16GetData( void )
{
    debugGetData = !debugGetData;
    debug = CAMCTL__stCameraOptions.u8ClkEnd;
    if( CAMCTL__stCameraOptions.u8ClkEnd == true )
    {
        return CAMCTL__au16LineBuffer;
    }
    else
    {
        return NULL;    
    }
}

void CAMCTL_vInit(void)
{
    CAMCTL__stCameraOptions.u8ActiveCapture = false;
    CAMCTL__stCameraOptions.u8ClkEnd = false;
    CAMCTL__stCameraOptions.enCaptureMode = nNone;
}

bool CAMCTL_boCalibrateCamera(uint16_t* pu16ThreshCalibration, uint8_t u8Frames2Wait)
{
    static uint8_t u8FrameCtr = 0;
    uint16_t* pu16DataBuffer;
    bool boConvDone = false;
    
    CAMCTL_vTriggerOneShotCapture();
    pu16DataBuffer = NULL;
    while( pu16DataBuffer == NULL )
    {
        pu16DataBuffer = CAMCTL_pu16GetData();
    }
    u8FrameCtr++;        
    if( u8FrameCtr > u8Frames2Wait )
    {
        u8FrameCtr = 0;
        boConvDone = true;
        memcpy( pu16ThreshCalibration, pu16DataBuffer, (BUFFER_LENGTH)*sizeof(uint16_t));
    }
    return boConvDone;
}