/** --- Includes --- */
#include "mbed.h"
#include "SDFileSystem.h"
#include "TimeManager.h"
#include "UartReceiver.h"
#include "CommandParser.h"
#include "SDDataStore.h"
#include "global.h"
#include "string.h"
#include "DeviceRepeater.h"
#include "Adxl372Drv.h"

/** --- Global Variables --- */
Serial uartStream(SERIAL_TX, SERIAL_RX);
bool uartOn = true;
#ifdef _DEBUG_PRINTF_
Serial dbg(PC_4, PC_5); /* Serial3_TX, Serial3_RX*/
#endif /* _DEBUG_PRINTF_ */

/** --- prototypes --- */
static void mainloop(void);

/** --- main --- */
int main()
{
    int deviceId = 0; 
    
    /** UART Initalizer */
    /* setup UART 115200, 8bit, Parity=None, stopbit:1bit  */
    /* https://os.mbed.com/users/okini3939/notebook/Serial_jp/ */
    uartStream.baud(115200);
    uartStream.format(8, Serial::None, 1);
#ifdef _DEBUG_PRINTF_
    /** UART Initalizer */
    /* setup UART 115200, 8bit, Parity=None, stopbit:1bit  */
    /* https://os.mbed.com/users/okini3939/notebook/Serial_jp/ */
    dbg.baud(115200);
    dbg.format(8, Serial::None, 1);
#endif /* _DEBUG_PRINTF_ */        
    dbgprintf("start debug console as 115200,8b,1\n");
    
    /* new timer manager */
    pTM = new TimeManager();
    /* Generate SDDataStore */
    pSds = new SDDataStore(pTM);
    /* Receive Buffer Control */
    pUR = new UartReceiver(&uartStream);
    
    /* create Device */
    pDevRept = new DeviceRepeater(deviceId, &Adxl372Simple);

    /* Generate Command parser as DeviceID = 0, ParsingRule = rules */
    pCP = new CommandParser(pUR, deviceId, rules, getNumOfRules);
    pCP->run();
        
    uprintf(":%d ACK 0004 0000\n", deviceId);
    uprintf(":%d WAK 0004 0000\n", deviceId);
    dbgprintf("start mainloop\n");
    mainloop();    
}

/****************************************************/
/* MainLoop (for User Button handling) */
/****************************************************/
static void mainloop(void)
{
    typedef enum e_offline_mode {
        OFFLINE_MODE_READY,
        OFFLINE_MODE_RUN,
        OFFLINE_MODE_END,
    } OfflineMode;
    
    DigitalOut myled(PB_7);
    DigitalOut ledY(PC_2);
    DigitalOut ledG(PC_3);

    DigitalIn btn(USER_BUTTON);
    OfflineMode state = OFFLINE_MODE_READY;
    int blinky = 0;
    myled = blinky;
    ledG = blinky;
    ledY = 0;

    while(1) {
        switch(state) {
        case OFFLINE_MODE_READY:
            myled = blinky;
            ledG = blinky;

            if (btn == 0) {
                uartOn = false;
                pCP->parse(":0 RRP 0010");
                pCP->parse(":0 RMC 001s");
                pCP->parse(":0 SDS 0000");
                pCP->parse(":0 CRS 0000");
                state = OFFLINE_MODE_RUN;
            }
            wait(0.2);
            break;        
        case OFFLINE_MODE_RUN:
            myled = blinky;
            ledG = blinky;

            if (pCP->parse(":0 CPS 0000") == 0) {
                pCP->parse(":0 SDE 0000");
                state = OFFLINE_MODE_END;
            }
            wait(1);
            break;
        case OFFLINE_MODE_END:
        default:
            myled = 1;
            ledG = 1;

            wait(5);
            break;
        }
        blinky = !blinky;
    }

}
