#include "mbed.h"
#include "rtos.h"
#include "Stingr.h" 

#define RX_BUFFER_SIZE              200
#define INITIAL_PAYLOAD_RX_STATUS   50
#define PAYLOAD_STATUS_WORKING      100
#define PAYLOAD_INIT_CORRECT        4

Serial stingrUART(p13, p14, 9600);  // tx, rx Comunicación Serial con el STINGR
Serial pc(USBTX, USBRX, 9600);      // tx, rx Comunicación Serial con la PC
I2CSlave slave(p9, p10);            // sda, scl

char buf_rx[RX_BUFFER_SIZE];
char comando_del_maestro;
int general_payload_status = 0;
int payload_init_variable = 0;

Stingr stingr;
Thread stingrR;

void stingrR_thread()
{
    while(1)
    {
        Thread::signal_wait(0x2);
        general_payload_status = PAYLOAD_STATUS_WORKING;                        // Indicador STINGR inicia trabajo
        
        stingr.command(buf_rx);                                                 // Run STINGR commands here
        
        Thread::wait(1500);
        general_payload_status = stingr.get_respChar();
        //general_payload_status = PAYLOAD_STATUS_FINISHED;                     // Indicador STINGR acabo trabajo
    }
}

void comando()
{
    comando_del_maestro = buf_rx[0];
    switch (comando_del_maestro)
    {
        // Command (1st call)
        case 'a':   // Query ESN                - returns y/n
        case 'b':   // Query Bursts             - returns # bursts left
        case 'c':   // Query Firmware           - returns y/n
        case 'd':   // Query Setup              - returns string
        case 'e':   // Query Hardware           - returns y/n
        case 'f':   // NAK command              - {DON'T USE}
        case 'g':   // Change Setup             - returns y/n
        case 'h':   // Send Data                - returns y/n
        case 'i':   // Abort Transmission       - returns y/n
        case 'j':   // Continuous transmission  - returns y/n (cont.)
        case 'k':   // Get Status               - returns string
        case 'l':   // Self Test                - returns y/n
        case 'm':   // Soft Reset               - returns nothing
        case 'z':   // Setup Reset              - returns y/n
            stingrR.signal_set(0x2);                                             // Run stingrR thread; STINGR activity for 5 seconds 
            break;
            
        //Status (2nd call)
        case '0':
            pc.printf("Payload status is: %d\r\n", general_payload_status);
            break;  
            
        default:
            pc.printf("Invalid command\r\n");
            break;         
    }
}

int main()
{
    pc.printf("Initialising...\n");  
    stingrR.start(callback(stingrR_thread)); 
    slave.frequency(400000);
    slave.address(0x1E);
    
    /*
    // The ESN is checked per init
    stingr.query_ESN();
    general_payload_status = stingr.get_respChar();
    if (general_payload_status == 'y')
    payload_init_variable++;
    
    // The Firmware is checked per init
    stingr.query_Firmware();
    general_payload_status = stingr.get_respChar();
    if (general_payload_status == 'y')
    payload_init_variable++;
    
    // The Hardware is checked per init
    stingr.query_Hardware();
    general_payload_status = stingr.get_respChar();
    if (general_payload_status == 'y')
    payload_init_variable++;
    
    // An internal self test of STINGR is done
    stingr.self_Test();
    general_payload_status = stingr.get_respChar();
    if (general_payload_status == 'y')
    payload_init_variable++;
    
    if (payload_init_variable == PAYLOAD_INIT_CORRECT)
    pc.printf("Init complete!\r\n");
    
    else
    pc.printf("Something went wrong\r\n");
    */
    
    general_payload_status = INITIAL_PAYLOAD_RX_STATUS;
    pc.printf("I'm ready!!\n\n");
    
    while (1)
    {
        int i = slave.receive();
        switch (i)
        {
            // Slave writes to master
            case I2CSlave::ReadAddressed:
                if (get_status_setup_flag == true)                                    //If OBC requested AB's status...
                {
                    //stingr.get_status_resp(get_status_setup_buffer);
                    slave.write(get_status_setup_buffer, sizeof(get_status_setup_buffer));  //Sends the complete buffer to OBC
                    get_status_setup_flag = false;                                    //Resets get_status_setup_flag
                    for (int i=0; i<50; i++) get_status_setup_buffer[i] = 0;          //Resets buffer
                }
                else
                {
                    slave.write(general_payload_status);
                }
                slave.stop();                                                   //Finishes communication with OBC
                
                comando();                                                      //Check the received command and do something                                     
                Thread::wait(100);
                
                for(int j = 0; j < sizeof(buf_rx); j++)
                {
                    buf_rx[j] = 0;                                              //Empty buffer
                }
                break;
            
            // Master writes to slave    
            case I2CSlave::WriteAddressed:
                slave.read(buf_rx, sizeof(buf_rx));
                break;
        }
    }
}