/*
 * mbed STINGR Library
 * Copyright (c) 2018
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#ifndef MBED_STINGR_H
#define MBED_STINGR_H

#include "mbed.h"
#include "rtos.h"

// Command codes
#define QUERY_ESN           'a'
#define QUERY_BURSTS        'b'
#define QUERY_FIRMWARE      'c'
#define QUERY_SETUP         'd'
#define QUERY_HARDWARE      'e'
#define NAK_COMMAND         'f'
#define SETUP               'g' 
#define SEND_DATA           'h' 
#define ABORT_TRANSMISSION  'i' 
#define CONT_TRANSMISSION   'j'
#define GET_STATUS          'k'
#define SELF_TEST           'l'
#define SOFT_RESET          'm'
#define SETUP_RESET         'z'

#define PYL_MSG_1_PKT       9
#define PYL_MSG_2_PKT       18
#define PYL_MSG_4_PKT       36
#define PYL_MSG_8_PKT       72
#define PYL_MSG_16_PKT      144

// Get status stuff
extern bool get_status_setup_flag;
extern char get_status_setup_buffer[50];

/** Stingr class.
 *  Used for Mbed communication to STINGR modem.
 *
 */
class Stingr {

public:

    // Constructor - This function runs first as it is the Constructor
    Stingr();
    
    // Accessors
    const char * get_resp() const;      // _resp string of characters
    char get_respChar();                // _resp character
    void get_status_resp(char * buf);    // _packet array of integers
    
    // Mutators
    void setPacketByte(int incomingByte);
    
    // Serial Packet processing functions
    void clearPacket();
    void printPacket();
    void waitCTS();          
    void postCommand();
    void command(char* com); 
    
    // STINGR command functions
    void query_ESN();                   // command 'a'
    void query_Bursts();                // command 'b'
    void query_Firmware();              // command 'c'
    void query_Setup();                 // command 'd'
    void query_Hardware();              // command 'e'
    void NAK_command();                 // command 'f'
    void _setup(char* b);               // command 'g'
    void send_Data(char* b);            // command 'h'
    void abort_Transmission();          // command 'i'
    
    void cont_Transmission();           // command 'j'
    void get_Status();                  // command 'k'
    void self_Test();                   // command 'l'
    void soft_Reset();                  // command 'm'
    void setup_Reset();                 // command 'z'
    
    // Additional functions
    uint16_t ModRTU_CRC(char* buf, int len);
    
    void respuesta();
    void PC_communication(); 
    
    int flag;
    int incomingByte;
    int num;
    
    int incomingByteR;
    char incomingByteX;
    char strx[200];
    
    Thread t1;
    Thread t2;
    Thread t3;
    
private:
    char _resp[200];
    char _respChar;
    char _packet[50];       //OJOOOOO!!! SE CAMBIO DE TIPO int A TIPO char
};

#endif


