#ifndef PAUSE_CPP
#define PAUSE_CPP
#include "mbed.h"

// http://infocenter.arm.com/help/index.jsp?topic=/com.arm.doc.dui0496b/BABDJCCI.html
#pragma diag_suppress 174 // suppress the warning "Expression has no effect".  This warning is displayed for each of these functions.



// these are various delays
inline void pause(uint32_t seconds) {
    for(seconds; seconds > 0; seconds--) for(uint32_t i = 0x1ffffff; i > 0; i--) asm("nop");
}

inline void pause_ms(uint32_t milliseconds) {
    for(milliseconds; milliseconds > 0; milliseconds--) for(uint32_t i = 0x8312; i > 0; i--) asm("nop");
}

inline void pause_us(uint32_t microseconds) {
    for(microseconds; microseconds > 0; microseconds--) for(uint32_t i = 0x21; i > 0; i--) asm("nop");
}

#endif 